import React, { useEffect, useState } from 'react';
import { message, Modal } from 'antd';
import { useSelector } from 'react-redux';
import styled from 'styled-components';
import { CommonAPI } from '@/api';
import { RootState } from '@/store';
import { GlobalDataState } from '@/store/module/globalData';

const QrcodeModalView = ({
  open,
  onCancel,
}: {
  open: boolean;
  onCancel: () => void;
}) => {
  // system
  const globalData = useSelector(
    (state: RootState) => state.globalData,
  ) as GlobalDataState;
  // 登录二维码的地址
  const [qrCodeData, setQrCodeData] = useState<string>();
  // 获取登录二维码
  const getQrcodeLogin = async () => {
    // 获取二维码
    const res = await CommonAPI.getAppletQRCode({
      page: globalData?.qrcodeModalPath || 'pages/welcome/index',
      scene: globalData?.qrcodeModalScene || 'type=share',
    });
    if (res && res.code === '200') {
      if (!res.result) {
        message.warning('获取登录二维码失败');
        return;
      }
      // 设置当前登录的二维码
      setQrCodeData(`data:image/png;base64,${res.result}`);
    }
  };
  // 组件挂载
  useEffect(() => {
    if (!open) return;
    getQrcodeLogin().then();
  }, [open]);
  return (
    <Modal
      title="提示"
      open={open}
      footer={null}
      onCancel={onCancel}
      width={350}
    >
      <QrcodeModalWrap>
        <div className="qrcode">
          {qrCodeData && (
            <img
              className="animate__animated animate__faster animate__fadeIn"
              style={{ width: '100%', height: '100%' }}
              src={qrCodeData}
              alt="云享飞小程序"
            />
          )}
        </div>
        <div className="title">请前往小程序继续操作</div>
      </QrcodeModalWrap>
    </Modal>
  );
};
export default QrcodeModalView;

export const QrcodeModalWrap = styled.div`
  position: relative;
  width: 100%;
  min-height: 16.8rem;
  display: flex;
  align-items: center;
  justify-content: flex-start;
  flex-direction: column;
  box-sizing: border-box;
  padding-top: 1rem;
  .qrcode {
    width: 12.68rem;
    height: 12.68rem;
    //background-image: url('https://file.iuav.com/file/sharefly-qrcode-wx.jpg');
    //background-size: 100% 100%;
    //background-size: cover;
    //background-position: center;
  }
  .title {
    color: #000;
    font-size: 13px;
    margin-top: 1rem;
    font-weight: bold;
  }
`;
