import React from 'react';
import { useDispatch, useSelector } from 'react-redux';
import AgreeModalView from '@/components/agreeModal/index';
import ContentView from '@/components/layout/content';
import FooterView from '@/components/layout/footer';
import HeaderView from '@/components/layout/header';
import { LayoutWrap } from '@/components/layout/styled';
import LoginModalView from '@/components/loginModal';
import QrcodeModalView from '@/components/qrcodeModal';
import ToastModalView from '@/components/toastModal';
import { RootState } from '@/store';
import { GlobalDataState, setGlobalData } from '@/store/module/globalData';

const LayoutView: React.FC<{
  children?: React.ReactNode;
  placeholder?: boolean;
  autoChange?: boolean;
  topDistance?: number;
  background?: string;
}> = ({
  children,
  placeholder = true,
  autoChange = false,
  topDistance = 0,
  background = 'transparent',
}) => {
  // store
  const dispatch = useDispatch();
  // system
  const globalData = useSelector(
    (state: RootState) => state.globalData,
  ) as GlobalDataState;
  // 关闭弹窗
  const handleModalClose = () => {
    dispatch(
      setGlobalData({
        loginModalVisible: false,
        qrcodeModalVisible: false,
        toastModalVisible: false,
      }),
    );
  };
  return (
    <LayoutWrap style={{ background }}>
      <HeaderView
        placeholder={placeholder}
        autoChange={autoChange}
        topDistance={topDistance}
      ></HeaderView>
      <ContentView>{children}</ContentView>
      <FooterView></FooterView>
      {/* 登录弹窗 */}
      <LoginModalView
        open={globalData?.loginModalVisible}
        onCancel={handleModalClose}
      />
      {/* 功能正在完善中 */}
      <QrcodeModalView
        open={globalData?.qrcodeModalVisible}
        onCancel={handleModalClose}
      />
      {/* 功能正在完善中 */}
      <ToastModalView
        open={globalData?.toastModalVisible}
        onCancel={handleModalClose}
      />
      {/* 协议弹窗 */}
      <AgreeModalView open={globalData?.agreeModalVisible} />
    </LayoutWrap>
  );
};

export default LayoutView;
