import React, { useEffect, useState } from 'react';
import { HomeAPI } from '@/api';
import { InterDataType } from '@/api/interface';
import { ListBannerImgType } from '@/api/interface/home';
import TabView01 from './comp/tabView01';
import TabView02 from './comp/tabView02';
import TabView03 from './comp/tabView03';
import TabView04 from './comp/tabView04';
import TabView05 from './comp/tabView05';
import { HomeTabWrap } from './styled';

// 分类列表类型
type CategoryListType = InterDataType<ListBannerImgType>;

const HomeTabView = () => {
  // 当前选中的项目
  const [currentIndex, setCurrentIndex] = useState<number>(0);
  // 一级分类列表
  const [categoryList, setCategoryList] = useState<CategoryListType>([]);
  // 获取一级分类列表
  const getCategoryList = async () => {
    const res = await HomeAPI.listBannerImg({
      moduleCode: 'HOME_MENU_NEW',
    });
    if (res && res.code === '200') {
      setCategoryList(res.result || []);
    }
  };
  // 选择分类
  const handleSelect = (index: number) => {
    setCurrentIndex(index);
  };
  // 组件挂载
  useEffect(() => {
    // 获取分类数据
    getCategoryList().then();
  }, []);
  // 渲染视图
  return (
    <HomeTabWrap>
      <div className="tab-label">
        <div className="label-head">分类</div>
        {categoryList?.map((i, j) => (
          <div
            className={`label-item flex-start ${
              currentIndex === j && 'item-active'
            }`}
            key={j}
            onClick={() => handleSelect(j)}
          >
            <img className="item-image" src={i.bannerImg} alt={i.bannerName} />
            <div className="item-name">{i.bannerName}</div>
          </div>
        ))}
      </div>
      <div className="tab-content">
        {/* 产品商城 */}
        {currentIndex === 0 && <TabView01 />}
        {/* 行业服务 */}
        {currentIndex === 1 && <TabView02 />}
        {/* 设备租赁 */}
        {currentIndex === 2 && <TabView03 />}
        {/* 执照培训 */}
        {currentIndex === 3 && <TabView04 />}
        {/* 飞手约单 */}
        {currentIndex === 4 && <TabView05 />}
      </div>
    </HomeTabWrap>
  );
};

export default HomeTabView;
