import {
  QueryGoodsInfoByCategorySub,
  GetAppCategoryInfo,
  AppMallGoodsDetails,
  GetCompanyInfoByBUId,
  LeaseGoodsDetailsType,
  LeaseTermInfoType,
} from '@/api/interface/mall';
import request from '../request';

export class MallAPI {
  // 小程序分类信息--含一二级分类
  static getAppCategoryInfo: GetAppCategoryInfo = (params) =>
    request.get('/pms/category/appCategoryInfo', { params });

  // 根据子分类查询商品信息
  static queryGoodsInfoByCategorySub: QueryGoodsInfoByCategorySub = (params) =>
    request.post('/pms/app/goods/queryGoodsInfoByCategorySub', params);

  // 小程序商品详情
  static appMallGoodsDetails: AppMallGoodsDetails = (params) =>
    request.get('/pms/app/goods/appMallGoodsDetails', { params });

  // pc-后台用户id单位查询
  static getCompanyInfoByBUId: GetCompanyInfoByBUId = (params) =>
    request.get('/userapp/company/getCompanyInfoByBUId', { params });

  // 租赁商品详情
  static leaseGoodsDetails: LeaseGoodsDetailsType = (params) =>
    request.get('/pms/app/lease/leaseGoodsDetails', { params });

  //  租赁-商品-租期信息
  static getLeaseTermInfo: LeaseTermInfoType = () =>
    request.post('/pms/lease/goods/getLeaseTermInfo');
}
