import {
  AllCommentListType,
  AppCategoryInfoType,
  AppGambitListsType,
  AppListPilotType,
  AppPublishListType,
  ForumDetailType,
  ForumListType,
  GetAppGambitListType,
  GetInfoById,
  GetPageHomeCategoriesType,
  GetSecondDistrictInfo,
  IndustryListPagesType,
  LeaseGoodsListType,
  ListBannerImgType,
  ListBrandInfoType,
  ListCompanyInfoByCoopIdType,
  ListNewsType,
  ListTenderInfoType,
  NewDetailsType,
  RecommendGoodsType,
  RequirementsListType,
} from '@/api/interface/home';
import request from '@/api/request';

export class HomeAPI {
  // 获取图片-小程序
  static listBannerImg: ListBannerImgType = (params) =>
    request.get('/release/module/listBannerImg', { params });

  // 小程序分类信息--含一二级分类
  static appCategoryInfo: AppCategoryInfoType = (params) =>
    request.get('/pms/category/appCategoryInfo', { params });

  // 一级行业列表
  static IndustryListPages: IndustryListPagesType = (params) =>
    request.post('/pms/industry/listPages', params);

  // 小程序——列表————飞手执照及能力认证
  static appListPilot: AppListPilotType = (params) =>
    request.post('/userapp/pilot/appListPilot', params);

  // 话题-列表（小程序）
  static getAppGambitList: GetAppGambitListType = (data) =>
    request.post('/release/dynamic/appGambitList', data);

  // 话题-话题下的帖子
  static getAppGambitLists: AppGambitListsType = (data) =>
    request.post('/release/gambit/appGambitLists', data);

  // 小程序-列表——需求发布
  static appPublishList: AppPublishListType = (params) =>
    request.post('/release/requirements/appPublishList', params);

  // 需求发布-需求类型
  static getRequirementsListType: RequirementsListType = () =>
    request.get('/release/requirements/listType');

  // 合作商家列表-根据合作标签id获取
  static listCompanyInfoByCoopId: ListCompanyInfoByCoopIdType = (params) =>
    request.get('/userapp/cooperation/listCompanyInfoByCoopId', { params });

  // 商品-推荐商品
  static getRecommendGoods: RecommendGoodsType = (params) =>
    request.get('/pms/app/goods/recommend', { params });

  // 项目资讯-新闻列表
  static getListNews: ListNewsType = (params) =>
    request.post('/release/industry-news/listNewsPage', params);

  // 项目资讯-招投标
  static getListTenderInfo: ListTenderInfoType = (params) =>
    request.post('/release/tender/listNewTenderInfo', params);

  // 租赁-品牌-列表
  static getListBrandInfo: ListBrandInfoType = (params) =>
    request.get('/pms/brand/listBrandInfo', { params });

  // web-首页分类数据-展示
  static getPageHomeCategories: GetPageHomeCategoriesType = (params) =>
    request.get('/pms/product/mall/getPageHomeCategories', { params });

  // 论坛列表
  static getForumList: ForumListType = (params) =>
    request.get('/release/dynamic/dynamicList', { params });

  // 论坛列表
  static getForumList1: ForumListType = (params) =>
    request.get('/release/dynamic/dynamicList1', { params });

  // 类型列表
  static leaseGoodsList: LeaseGoodsListType = (params) =>
    request.post('/pms/app/lease/leaseGoodsList', params);

  // 项目资讯-新闻详情
  static getNewsDetail: NewDetailsType = (params) =>
    request.get('/release/industry-news/details', { params });

  // 查询-招标快讯详情
  static getInfoById: GetInfoById = (params) =>
    request.get('/release/tender/infoById', { params });

  // 地域
  static getSecondDistrictInfo: GetSecondDistrictInfo = (params) =>
    request.get('/pms/webDevice/getSecondDistrictInfo', params);

  // 论坛-详情
  static getForumDetail: ForumDetailType = (params, config) =>
    request.get('/release/dynamic/dynamicDetails', { params, ...config });

  // 话题-所有评论
  static getAllCommentList: AllCommentListType = (params) =>
    request.post('/release/gambit/allCommentList', params);
}
