import {
  GetAccountInfo,
  GetAppletQRCode,
  GetLoginInfo,
  GetVerifyCodeAuthType,
  GetVerifyCodeType,
  TestPhoneLogin,
  WebLoginType,
  WebRegisterType,
} from '@/api/interface/common';
import request from '../request';

export class CommonAPI {
  // 测试接口
  static getPageHomeCategories: any = (params: any) =>
    request.get('/pms/product/mall/getPageHomeCategories', { params });

  // 测试接口
  static cooperationListTag: any = (params: any) =>
    request.get('/userapp/cooperation/listTag', { params });

  // 获取二维码
  static getAppletQRCode: GetAppletQRCode = (params) =>
    request.get('/userapp/wx/getAppletQRCode', { params });

  // 查询登录信息
  static getLoginInfo: GetLoginInfo = (params) =>
    request.get('/userapp/temp-auth/getLoginInfo', { params });

  // 获取用户信息
  static getAccountInfo: GetAccountInfo = (params) =>
    request.get('/userapp/user-account/info', { params });

  // 测试-手机号登录
  static testPhoneLogin: TestPhoneLogin = (params) =>
    request.get('/userapp/auth/testPhoneLogin', { params });

  // 获取修改手机获取验证码
  static getVerifyCode: GetVerifyCodeType = (params) =>
    request.get('/userapp/user-account/getVerifyCode', { params });

  // web注册获取手机号验证码
  static getVerifyCodeAuth: GetVerifyCodeAuthType = (params) =>
    request.get('/userapp/auth/getVerifyCode', { params });

  // web端注册
  static webRegister: WebRegisterType = (params) =>
    request.post('/userapp/auth/webRegister', params);

  // web端账号密码登录
  static webLogin: WebLoginType = (params) =>
    request.post('/userapp/auth/webLogin', params);
}
