// user.ts
import { createSlice } from '@reduxjs/toolkit';
import { HYDRATE } from 'next-redux-wrapper';
import { InterDataType } from '@/api/interface';
import { GetAccountInfo } from '@/api/interface/common';

export type UserInfoState = InterDataType<GetAccountInfo>;

const initialState: UserInfoState | {} = {};

const userInfoSlice = createSlice({
  name: 'userInfo',
  initialState,
  reducers: {
    setUserInfo: (state, action) => {
      return action.payload;
    },
  },
  extraReducers: {
    // hydrated 用于获取服务端注入的state并选择更新
    [HYDRATE]: (state, action) => {
      return {
        ...action.payload.user,
      };
    },
  },
});

export const { setUserInfo } = userInfoSlice.actions;
export default userInfoSlice.reducer;
