import React from 'react';
import { createCache, extractStyle, StyleProvider } from '@ant-design/cssinjs';
import Document, { Head, Html, Main, NextScript } from 'next/document';
import type { DocumentContext } from 'next/document';
import { ServerStyleSheet } from 'styled-components';

const MyDocument = () => (
  <Html lang="zh-Hans">
    <Head>
      <meta charSet="UTF-8" />
      <link
        rel="icon"
        type="image/svg+xml"
        href="/assets/image/logo/logo.png"
      />
      <meta name="viewport" content="width=device-width, initial-scale=1.0" />
      {/* eslint-disable-next-line */}
      <title>云享飞</title>
      {/* <title>【云享飞 iuav.com】无人机分类信息 - 让世界为天空所用</title> */}
      {/*  强制使用浅色模式 */}
      <meta name="color-scheme" content="light" />
    </Head>
    <body>
      <Main />
      <NextScript />
    </body>
  </Html>
);

MyDocument.getInitialProps = async (ctx: DocumentContext) => {
  const cache = createCache();
  const originalRenderPage = ctx.renderPage;
  const sheet = new ServerStyleSheet();
  try {
    ctx.renderPage = () =>
      originalRenderPage({
        enhanceApp: (App) => (props) => (
          <StyleProvider cache={cache}>
            <App {...props} />
          </StyleProvider>
        ),
      });

    const initialProps = await Document.getInitialProps(ctx);
    const style = extractStyle(cache, true);
    return {
      ...initialProps,
      styles: (
        <>
          {initialProps.styles}
          {sheet.getStyleElement()}
          <style dangerouslySetInnerHTML={{ __html: style }} />
        </>
      ),
    };
  } finally {
    sheet.seal();
  }
};

export default MyDocument;
