import { useState, useEffect } from 'react';

import { Space, Button, Collapse } from 'antd';

import { FilterOptionResp, InfoList } from '../../api';
import styles from '../../index.module.scss';

type Props = {
  onChange: (id: FilterOptionResp) => void;
  typeName: string;
  dataValue: InfoList[];
};

export default function CategoryItem(props: Props) {
  const [data, setData] = useState<FilterOptionResp[]>([]);

  useEffect(() => {
    setData(props.dataValue || []);
  }, []);

  const onClick = (item: FilterOptionResp) => {
    props.onChange({
      id: item.id,
      name: `${props.typeName}：${item.name}`,
    });
  };

  const showCount = 9; // 展示数量

  return (
    <div className={styles.filterItem}>
      <div className={styles.filterItemTitle}>{props.typeName}：</div>
      <div className={`${styles.filterItemMain} ${data.length <= showCount && styles.disabled}`}>
        <Collapse ghost collapsible='icon' expandIconPosition='end' style={{ width: '100%' }}>
          <Collapse.Panel
            header={
              <Space size={[40, 0]}>
                {data.slice(0, showCount).map((item) => {
                  return (
                    <Button type='link' key={item.id} onClick={(e) => onClick(item)}>
                      {item.name}
                    </Button>
                  );
                })}
              </Space>
            }
            key='1'
          >
            <Space size={40}>
              {data.slice(showCount).map((item) => {
                return (
                  <Button type='link' key={item.id} onClick={(e) => onClick(item)}>
                    {item.name}
                  </Button>
                );
              })}
            </Space>
          </Collapse.Panel>
        </Collapse>
      </div>
    </div>
  );
}
