import request, { Response } from '~/api/request';

export interface ListPageJobInfoParams {
  pageNo: number;
  pageSize: number;
  appTypeId?: number;
  industryId?: number;
  inspectionName?: string;
  string?: number;
  regionId?: number;
}

export interface Job {
  id: number;
  serviceName: string;
  teamName: string;
  price: number;
  inspComtAmount: number;
}

export interface ListPageJobInfoResp {
  pageNo: 1;
  pageSize: 10;
  list: Array<Job>;
  totalCount: 0;
  totalPage: 0;
}

export default {
  //web-作业服务-分页
  listPageJobServicesInfo: (
    params: ListPageJobInfoParams,
    option: {},
  ): Promise<Response<ListPageJobInfoResp>> => {
    return request('/pms/backstage/work/queryWorkServiceList', 'post', params, option);
  },
};
