import React, { useState } from "react";
import { Modal } from "antd";
import Image from "next/image";


type Props = {
  open: boolean;
  onCancel: () => void;
};

export default function loginModal(props: Props) {
  return (
    <>
      <Modal
        open={props.open}
        onCancel={props.onCancel}
        width={400}
        footer={null}
      >
        <div
          style={{
            fontSize: 20,
            fontFamily: "MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI",
            fontWeight: "bold",
            color: "#000",
            marginTop: 17,
            marginBottom: 48,
            textAlign: "center",
          }}
        >
          欢迎来到云享飞
        </div>
        <Image
          alt=""
          src=""
          width={160}
          height={160}
          style={{ margin: "auto", display: "block" }}
        ></Image>
        <div
          style={{
            marginTop: 39,
            marginBottom: 52,
            fontSize: 14,
            fontFamily: "MicrosoftYaHei",
            color: "#3E454D",
            textAlign: "center",
          }}
        >
          打开微信扫一扫
        </div>
      </Modal>
    </>
  );
}
