import React, { useState } from "react";
import { Avatar, Button, Space, Tabs } from "antd";
import type { TabsProps } from "antd";
import styles from "./index.module.scss";
import { useRouter } from "next/router";
import LoginModal from "~/components/loginModal";
import { useUser } from "~/lib/hooks";

const items: TabsProps["items"] = [
  {
    key: "/home",
    label: `  首页  `,
  },
  {
    key: "/jobServices",
    label: `作业服务`,
  },
  {
    key: "/equipmentLeasing",
    label: `设备租赁`,
  },
  {
    key: "/flyingHandService",
    label: `飞手服务`,
  },
  {
    key: "/mall",
    label: `产品商城`,
  },
  {
    key: "/projectInfo",
    label: `项目资讯`,
  },
  {
    key: "/forum",
    label: `社区论坛`,
  },
];

export default function NavHeader() {
  const router = useRouter();
  const currentPath = router.asPath;
  const user = useUser();

  console.log("currentHash", currentPath);
  const onChange = (key: string) => {
    console.log(key);
    router.push(key);
  };

  const [isModalOpen, setIsModalOpen] = useState(false);

  const showModal = () => {
    setIsModalOpen(true);
  };

  const handleCancel = () => {
    setIsModalOpen(false);
  };

  return (
    <div className={styles.navHeader}>
      <div className={styles.nav}>
        <div className={styles.logo}></div>
        <Tabs
          className={styles.tabs}
          defaultActiveKey={currentPath}
          items={items}
          onChange={onChange}
        />
        <Space size={16} className={styles.btns}>
          <Button type="primary" className={styles.btn1}>
            + 发布需求
          </Button>
          <Button className={styles.btn2}>入驻加盟</Button>
        </Space>
        {user ? (
          <div className={styles.haedImg}>
            <Avatar size={48} style={{ background: "#fff" }}></Avatar>
          </div>
        ) : (
          <Button
            type="text"
            onClick={showModal}
            style={{ fontWeight: "bold", fontSize: 16 }}
          >
            登录
          </Button>
        )}
      </div>
      <LoginModal open={isModalOpen} onCancel={handleCancel}></LoginModal>
    </div>
  );
}
