import request, { Response } from "~/api/request"

export interface OrderDetailResp {
  id: number;
  orderNo: string;
  createTime: number;
  wareInfoId: number;
  wareNo: string;
  wareTitle: string;
  wareImg: string;
  skuInfoId?: any;
  skuTitle?: any;
  repoAccountId: number;
  uid: string;
  buyerName?: any;
  buyerPhone: string;
  unitPrice: number;
  wareNum: number;
  shouldPay: number;    //应付款金额
  actualPay: number;    //实收款金额
  orderType?: any;
  deposit: number;
  rentPrice: number;
  startDate: number;
  endDate: number;
  payDay: number;
  tranStatus: string;
  exWare?: any;
  remark: string;
  pfRemark?: any;
  shutReason?: any;
  payNo?: any;
  payTime?: any;
  sendWareTime?: any;
  receipt: Receipt;
  orderRefund?: any;
  express?: any;
  refundExpress?: any;
  vcus?: any;
  returnTime?: any;
  couponId?: any;
  specsId?: any;
  balance?: any;
  doing: string;
  waiting: string;
  leaseOrderStatus: string;
  nickName: string;
  wareDescription: string;
}

interface Receipt {
  id: number;
  receiptMethod: number;
  takeName: string;
  takePhone: string;
  region: string;
  detailAddress: string;
  repoName?: any;
  repoAddress?: any;
  bookPhone?: any;
  sendExCode?: any;
  sendExNo?: any;
  sendAddress?: any;
  renMethod?: any;
  renPhone?: any;
  renName?: any;
  renExCode?: any;
  renExNo?: any;
  renAddress?: any;
  renRepoName?: any;
  renRepoAddr?: any;
  renRepoPhone?: any;
}

export interface UserWalletResp {
  id: number;
  repoAccountId: number;
  cashAmt: number;
  cashPaid: number;
  cashFreeze: number;
  remark?: any;
  phoneNum?: any;
  userName?: any;
  nickName?: any;
  portType?: any;
  uid?: any;
}

export default {
  //订单详情
  orderDetail(params: {
    orderNo: string
  }): Promise<Response<OrderDetailResp>> {
    return request('/oms/RentalOrders/orderDetail', 'get', params);
  },
  //获取用户钱包
  userWallet(): Promise<Response<UserWalletResp>> {
    return request('/payment/repocash/userWallet')
  },
  //租赁——订单支付
  orderPayment(params: { orderNo: string }) {
    return request('/payment/repocash/orderPayment', 'post', params)
  }
}