import styled from 'styled-components'

export const Box = styled.div`
  box-sizing: border-box;
  width: 1200px;
  background-color: #fff;
  padding: 42px 0 24px 24px;
  .item {
    display: flex;
    &-right {
      height: 300px;
      margin-left: 30px;
      .title {
        height: 26px;
        font-size: 28px;
        margin-top: 5px;
        font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
        font-weight: bold;
        color: #090909;
        line-height: 26px;
      }
      .function {
        display: flex;
        align-items: center;
        justify-content: space-evenly;
        width: 375px;
        height: 45px;
        margin-top: 17px;
        background: linear-gradient(90deg, #d7f7f5 0%, #eefde9 100%);
        &.not {
          background: none;
        }
        &-item {
        }
      }
      .menoy {
        margin-top: 17px;
        font-size: 32px;
        color: #ef2e00;
        &-left {
          width: 79px;
          height: 41px;
          font-size: 32px;
          font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
          font-weight: bold;
          color: #ef2e00;
          line-height: 41px;
        }
        &-right {
          width: 40px;
          height: 20px;
          font-size: 16px;
          font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
          font-weight: bold;
          color: #ef2e00;
          line-height: 20px;
        }
      }
      .classification {
        margin-top: 28px;
        width: 375px;
        height: 50px;
        .label {
          height: 21px;
          font-size: 16px;
          font-family: MicrosoftYaHei;
          color: #9a9a9a;
          line-height: 21px;
          margin-right: 36px;
        }
        .value {
          height: 21px;
          font-size: 16px;
          font-family: MicrosoftYaHei;
          color: #151515;
          line-height: 21px;
        }
        .top {
          display: flex;
          justify-content: space-between;
          align-items: center;
          .left {
          }
          .right {
            .selectItem {
              .ant-select-selection-placeholder {
                color: #000;
              }
            }
          }
        }
        .bottom {
          margin-top: 5px;
        }
      }
      .botton-btn {
        margin-top: 30px;
        .btn-left {
          width: 207px;
          height: 40px;
          background-color: #ffe4d1;
          border: 1px solid #ebbaaf;
          font-family: MicrosoftYaHei;
          color: #ff552d;
          letter-spacing: 1px;
          margin-right: 12px;
        }
        .btn-right {
          width: 207px;
          height: 40px;
          background: #ff552d;
          font-family: MicrosoftYaHei;
          color: #ffffff;
          letter-spacing: 1px;
        }
      }
    }
  }

  .flow-path {
    width: 100%;
    height: 192px;
    text-align: center;
    margin-top: 72px;
    position: relative;
    .image {
      margin: 0 auto;
    }
  }
  .prompt {
    width: 420px;
    height: 25px;
    font-size: 20px;
    font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
    font-weight: bold;
    color: #2b2b2b;
    line-height: 25px;
    margin: 30px auto 58px auto;
  }
  .divider {
    display: flex;
    justify-content: center;
    margin: 46px 0 30px !important;

    &::before {
      width: 65px !important;
    }

    &::after {
      width: 65px !important;
    }

    .ant-divider-inner-text {
      font-size: 16px;
      font-family: PingFangSC-Regular, PingFang SC;
      font-weight: 400;
      color: #989898;
    }
  }
  .application {
    .title {
      display: flex;
      align-items: center;
      padding-bottom: 25px;
      .left {
        width: 58px;
        height: 58px;
        background: #d8d8d8;
        border-radius: 2px;
      }
      .right {
        margin-left: 15px;
        .top {
          .tag {
            font-size: 14px;
            font-family: PingFangSC-Regular, PingFang SC;
            font-weight: 400;
            color: #ff0f0f;
          }
          .money {
            font-size: 22px;
            font-family: PingFangSC-Medium, PingFang SC;
            font-weight: 500;
            color: #ff0f0f;
          }
          .unit {
            font-size: 12px;
            font-family: PingFangSC-Regular, PingFang SC;
            font-weight: 400;
            color: #ff0f0f;
          }
        }
        .bottom {
          width: 65px;
          height: 18px;
          font-size: 13px;
          font-family: PingFangSC-Regular, PingFang SC;
          font-weight: 400;
          color: #121212;
          line-height: 18px;
        }
      }
    }
    .form-data {
      .tagsData {
        position: relative;
        &.disable {
          cursor: no-drop;
        }
        &.tagsDisable::after {
          content: '缺货';
          position: absolute;
          top: -10px;
          right: -10px;
          border-radius: 5px 0;
          width: 37px;
          height: 14px;
          line-height: 14px;
          text-align: center;
          background-color: #ccc;
          font-size: 12px;
          color: rgb(248, 248, 248);
        }
      }
      .num-box {
        display: flex;
        justify-content: space-between;
        align-items: center;
        .num-left {
          display: flex;
          align-items: center;
          .label {
            font-size: 14px;
            font-family: PingFangSC-Regular, PingFang SC;
            font-weight: 400;
            color: #121212;
            margin-right: 5px;
          }
        }
      }
    }
  }
  .applicationDate {
    .title {
      display: flex;
      align-items: center;
      .left {
        width: 10px;
        cursor: pointer;
      }
      .right {
        flex: 1;
        text-align: center;
      }
    }
    .bottom-item {
      display: flex;
      justify-content: space-between;
      align-items: center;
      height: 50px;
      line-height: 50px;
      border-bottom: 1px solid #d9d9d9;
      .label {
        font-size: 14px;
        font-family: ArialMT;
        color: #2f2f2f;
      }
      .price {
        display: flex;
        .left {
          font-size: 14px;
          font-family: Arial-BoldMT, Arial;
          font-weight: normal;
          color: #ff552d;
          margin-right: 4px;
        }
        .right {
          font-size: 12px;
          font-family: PingFangSC-Regular, PingFang SC;
          color: #959595;
        }
      }
    }
  }
`
