import React from 'react';
import styled from 'styled-components';
import { InterDataType } from '@/api/interface';
import { AppCategoryInfoType } from '@/api/interface/home';

// 分类类型
type CategoryType = InterDataType<AppCategoryInfoType>;

const StoreProductCategoryView: React.FC<{
  category: CategoryType;
  current: number;
  onSelect: (index: number) => void;
}> = ({ category, current, onSelect }) => {
  return (
    <StoreProductCategoryWrap className="flex-center">
      <div className="category-label">所有分类：</div>
      {category?.map((i, j) => (
        <div
          key={j}
          className={`category-item ${current === j && 'item-active'}`}
          onClick={() => onSelect?.(j)}
        >
          {i.name}
        </div>
      ))}
    </StoreProductCategoryWrap>
  );
};

export default StoreProductCategoryView;
// 样式
const StoreProductCategoryWrap = styled.div`
  position: relative;
  width: 100%;
  min-height: 3rem;
  background: #2f2f2f;
  .category-label {
    font-weight: 400;
    color: #ffffff;
    line-height: 1.11rem;
    user-select: none;
  }
  .category-item {
    position: relative;
    font-weight: 400;
    color: #ffffff;
    line-height: 3rem;
    box-sizing: border-box;
    padding: 0 1.11rem;
    cursor: pointer;
    &:hover {
      background: #9f9f9f;
    }
  }
  .item-active {
    background: #9f9f9f;
  }
`;
