import React, { useEffect, useState } from 'react';
import { Tabs, TabsProps } from 'antd';
import { useSelector } from 'react-redux';
import styled from 'styled-components';
import { HomeAPI } from '@/api';
import { InterListType, InterReqListType } from '@/api/interface';
import { ListCompanyInfoByCoopIdType } from '@/api/interface/home';
import BreadcrumbView from '@/components/breadcrumb';
import LayoutView from '@/components/layout';
import MapContainer from '@/components/map';
import { AddressState } from '@/store/module/address';

// 请求类型
type ReqType = InterReqListType<ListCompanyInfoByCoopIdType>;
// 列表类型
type ListType = InterListType<ListCompanyInfoByCoopIdType>;
// tab列表
const items: TabsProps['items'] = [
  { key: '5', label: '飞手团队' },
  { key: '3', label: '租赁商家' },
  { key: '4', label: '培训机构' },
  { key: '10', label: '维修网点' },
];
const StoreMapPage = () => {
  // address
  const address = useSelector((state: any) => state.address) as AddressState;
  // tab栏切换
  const [tabIndex, setTabIndex] = useState('5');
  // tab栏切换监听
  const handleTabChange: TabsProps['onChange'] = (e) => {
    setTabIndex(e);
    getServiceBitmap({ coopId: Number(e) }).then();
  };
  // 网点列表
  const [mapList, setMapList] = useState<Array<ListType[0] & { name: string }>>(
    [],
  );
  // 统一获取网点数据
  const getServiceBitmap = async (data?: ReqType) => {
    const res = await HomeAPI.listCompanyInfoByCoopId({
      lon: address?.longitude || 113.93029,
      lat: address?.latitude || 22.53291,
      pageNo: 1,
      pageSize: 999,
      coopId: Number(tabIndex),
      ...data,
    });
    if (res && res.code === '200') {
      // console.log('统一获取网点数据 --->', res);
      const list = (res.result.list || [])?.map((i) => ({
        ...i,
        name: i.brandName || i.companyName,
      }));
      setMapList(list);
    }
  };
  // 组件挂载
  useEffect(() => {
    getServiceBitmap().then();
    // console.log('address ===>', address);
  }, []);
  return (
    <LayoutView>
      <StoreMapWrap>
        {/* 面包屑 */}
        <BreadcrumbView />
        <div className="map-tab">
          <Tabs
            defaultActiveKey={tabIndex}
            items={items}
            size={'large'}
            onChange={handleTabChange}
          />
        </div>
        <div className="map-wrap">
          <div className="map-list scroll-view">
            <div className="list-title">网点信息</div>
            {mapList?.map((i, j) => (
              <div className="list-item list-none" key={j}>
                <img className="image" src={i?.brandLogo} alt={i?.name} />
                <div className="name">{i.name}</div>
              </div>
            ))}
          </div>
          <div className="map-view">
            <MapContainer
              list={mapList}
              center={[address?.longitude, address?.latitude]}
            />
          </div>
        </div>
      </StoreMapWrap>
    </LayoutView>
  );
};

export default StoreMapPage;
// 样式
const StoreMapWrap = styled.div`
  position: relative;
  max-width: 1190px;
  box-sizing: border-box;
  padding: 2rem 0 0 0;
  margin: 0 auto;
  .map-tab {
    position: relative;
    width: 100%;
    justify-content: center;
    align-items: center;
    margin-bottom: 0.5rem;
    .ant-tabs-tab {
      width: 268px;
      justify-content: center;
    }
  }
  .map-wrap {
    position: relative;
    width: 100%;
    height: 38rem;
    box-sizing: border-box;
    display: flex;
    align-items: center;
    justify-content: flex-start;
    flex-wrap: nowrap;
    margin-bottom: 2rem;
    border: 0.04rem solid #e3e3e3;
    .map-list {
      position: relative;
      width: 25%;
      height: 100%;
      overflow: hidden;
      overflow-y: scroll;
      box-sizing: border-box;
      padding: 0.8rem 1rem;
      .list-title {
        font-size: 14px;
        font-weight: bold;
        margin-bottom: 0.5rem;
        box-sizing: border-box;
        padding-left: 0.5rem;
      }
      .list-item {
        position: relative;
        width: 100%;
        height: 2.4rem;
        display: flex;
        align-items: center;
        justify-content: flex-start;
        box-sizing: border-box;
        padding: 0 0.5rem;
        cursor: pointer;
        .image {
          width: 1.68rem;
          height: 1.68rem;
          border-radius: 0.25rem;
          margin-right: 0.5rem;
        }
        .name {
          font-weight: bold;
          color: #333333;
          &:hover {
            color: #ff552d;
          }
        }
        &:hover {
          background: #fff4f4;
        }
      }
    }
    .map-view {
      position: relative;
      width: 75%;
      height: 100%;
    }
  }
`;
