import React from 'react';
import { HomeAPI } from '@/api';
import { InterListType } from '@/api/interface';
import { ListBrandInfoType } from '@/api/interface/home';
import RentView from '@/pages/rent/_view';
import { wrapper } from '@/store';

// 分类列表类型
type CategoryListType = InterListType<ListBrandInfoType>;
// 每次加载页面都会执行
export const getServerSideProps = wrapper.getServerSideProps(
  (_store) => async () => {
    // 分类数据
    let categoryList: CategoryListType = [];
    // 获取各个目录及分类信息
    const getCategoryInfo = async () => {
      const res = await HomeAPI.getListBrandInfo({
        pageNo: 1,
        pageSize: 999,
      });
      if (res && res.code === '200') {
        categoryList = res.result?.list || [];
      }
    };
    // 依次获取接口数据
    await (async () => {
      await Promise.all([getCategoryInfo()]);
    })();
    return { props: { categoryList } };
  },
);
const RentPageView: React.FC<{
  categoryList: CategoryListType;
}> = (props) => <RentView {...props} />;

export default RentPageView;
