import React from 'react';
import styled from 'styled-components';
import HomeBannerView from '@/pages/home/comp/home-banner/_index';
import HomeBrandView from '@/pages/home/comp/home-brand/_index';
import HomeCourseView from '@/pages/home/comp/home-course/_index';
import HomeFlyerView from '@/pages/home/comp/home-flyer/_index';
import HomeForumView from '@/pages/home/comp/home-forum/_index';
import HomeHeadView from '@/pages/home/comp/home-head/_index';
import HomeNewsView from '@/pages/home/comp/home-news/_index';
import HomeTabView from '@/pages/home/comp/home-tab/_index';
import HomeTaskView from '@/pages/home/comp/home-task/_index';
import HomeTopicView from '@/pages/home/comp/home-topic/_index';

const HomePageView = () => {
  return (
    <HomeViewWrap>
      {/* 科比特航空 */}
      <HomeHeadView />
      {/* 主页搜索 */}
      {/* <HomeSearchView /> */}
      {/* 页面布局 */}
      <div className="home-wrap flex-between align-start">
        {/* 主页分类 */}
        <HomeTabView />
        {/* 抢单大厅 */}
        <HomeTaskView />
        {/* 品牌企业 */}
        <HomeBrandView />
        {/* 话题/论坛 */}
        <HomeForumView />
        {/* 右侧边栏 */}
        <div className="relative w-[30%]">
          {/* 飞手列表 */}
          <HomeFlyerView />
          {/* 热门课程 */}
          <HomeCourseView />
          {/* 热门话题 */}
          <HomeTopicView />
          {/* 首页轮播 */}
          <HomeBannerView />
          {/* 新闻快讯 */}
          <HomeNewsView />
        </div>
      </div>
    </HomeViewWrap>
  );
};

export default HomePageView;
// 样式
const HomeViewWrap = styled.div`
  .home-wrap {
    position: relative;
    max-width: 1190px;
    box-sizing: border-box;
    margin: 0 auto;
  }
`;
