import React, { useEffect, useState } from 'react';
import { RightOutlined } from '@ant-design/icons';
import { Empty, Pagination } from 'antd';
import { useRouter } from 'next/router';
import styled from 'styled-components';
import { ServiceAPI } from '@/api';
import { InterListType, InterReqType } from '@/api/interface';
import { GetListAPPCompanyInspectionPageType } from '@/api/interface/service';
import ServiceListItem from '@/components/serviceItem/item';

// 请求参数类型
type ReqType = InterReqType<GetListAPPCompanyInspectionPageType>;
// 服务列表
type ListType = InterListType<GetListAPPCompanyInspectionPageType>;

const HomeTabView01 = () => {
  // 路由钩子
  const router = useRouter();
  // 分页数据
  const [pagination, setPagination] = useState({
    pageNo: 1,
    pageSize: 8,
    totalCount: 0,
  });
  // 服务列表
  const [inspectionList, setInspectionList] = useState<ListType>([]);
  // 获取服务列表
  const getInspectionList = async ({ data }: { data?: ReqType }) => {
    const res = await ServiceAPI.getListAPPCompanyInspectionPage({
      pageNo: pagination.pageNo,
      pageSize: pagination.pageSize,
      ...data,
    });
    if (res && res.code === '200') {
      const { list, pageNo, pageSize, totalCount } = res.result;
      setPagination({
        pageNo,
        pageSize,
        totalCount,
      });
      setInspectionList(list || []);
      // console.log('获取服务列表 --->', res);
    }
  };
  // 翻页回调
  const handlePageChange = async (pageNo: number, pageSize: number) => {
    await getInspectionList({ data: { pageNo, pageSize } });
  };
  // 跳转更多列表
  const handleMore = async () => {
    await router.push('./service');
  };
  // componentDidMount
  useEffect(() => {
    getInspectionList({}).then();
  }, []);
  return (
    <HomeTabWrap01 className="animate__animated animate__fast animate__fadeIn">
      <div className="tab-title flex-between w-full">
        <div className="label flex-start ">
          <div className="title select-none">推荐服务</div>
          <div
            className="action flex-end cursor-pointer text-primary"
            onClick={handleMore}
          >
            <div className="text">更多</div>
            <RightOutlined className="text-primary" style={{ fontSize: 10 }} />
          </div>
        </div>
        <Pagination
          showSizeChanger={false}
          onChange={handlePageChange}
          defaultPageSize={pagination.pageSize}
          current={pagination.pageNo}
          total={pagination.totalCount}
        />
      </div>
      <div className="tab-list flex-start w-full">
        {inspectionList?.length ? (
          inspectionList?.map((i, j) => <ServiceListItem key={j} detail={i} />)
        ) : (
          <div className="list-empty flex-center h-24 w-full">
            <Empty />
          </div>
        )}
      </div>
    </HomeTabWrap01>
  );
};

export default HomeTabView01;
const HomeTabWrap01 = styled.div`
  position: relative;
  box-sizing: border-box;
  padding-top: 1.58rem;
  width: 100%;
  .tab-title {
    margin-bottom: 1.33rem;
    .label {
      align-items: center;
      .title {
        font-weight: 600;
        font-size: 1.33rem;
        color: #333333;
        margin-right: 2rem;
      }
      .action {
        font-weight: 500;
        font-size: 0.78rem;
        color: #ff552d;
        margin-top: 0.15rem;
        .text {
          margin-right: 0.25rem;
        }
      }
    }
  }
`;
