import React, { useEffect, useState } from 'react';
import { Affix } from 'antd';
import styled from 'styled-components';
import { HomeAPI } from '@/api';
import { InterDataType } from '@/api/interface';
import { ListBannerImgType } from '@/api/interface/home';
import HomeTabView01 from '@/pages/home/comp/home-tab/_tab01';
import HomeTabView02 from '@/pages/home/comp/home-tab/_tab02';
import HomeTabView03 from '@/pages/home/comp/home-tab/_tab03';
import HomeTabView04 from '@/pages/home/comp/home-tab/_tab04';
import HomeTabView05 from '@/pages/home/comp/home-tab/_tab05';

// 分类列表类型
type CategoryListType = InterDataType<ListBannerImgType>;

const HomeTabView = () => {
  // 当前选中的项目
  const [currentIndex, setCurrentIndex] = useState<number>(0);
  // 一级分类列表
  const [categoryList, setCategoryList] = useState<CategoryListType>([]);
  // 获取一级分类列表
  const getCategoryList = async () => {
    const res = await HomeAPI.listBannerImg({
      moduleCode: 'HOME_MENU_NEW',
    });
    if (res && res.code === '200') {
      setCategoryList(res.result || []);
    }
  };
  const handleScrollToTop = () => {
    // 滚动到顶部
    window.scrollTo({ top: 200, behavior: 'smooth' });
  };
  // 组件挂载
  useEffect(() => {
    // 获取分类数据
    getCategoryList().then();
  }, []);
  return (
    <HomeTabWrap>
      <Affix offsetTop={58}>
        <div className="tab-sub">
          {categoryList?.map((i, j) => (
            <div
              className={`tab-item flex-center cursor-pointer ${
                currentIndex === j && 'item-active'
              }`}
              key={j}
              onClick={() => {
                setCurrentIndex(j);
                handleScrollToTop();
              }}
            >
              <img className="image" src={i?.bannerImg} alt={i?.bannerName} />
              <div className="title">{i?.bannerName}</div>
            </div>
          ))}
        </div>
      </Affix>
      <div className="tab-content">
        {/* 行业服务 */}
        {categoryList?.[currentIndex]?.bannerName?.includes('服务') && (
          <HomeTabView01 />
        )}
        {/* 飞手约单 */}
        {categoryList?.[currentIndex]?.bannerName?.includes('飞手') && (
          <HomeTabView02 />
        )}
        {/* 技能课堂 */}
        {categoryList?.[currentIndex]?.bannerName?.includes('课堂') && (
          <HomeTabView03 />
        )}
        {/* 出口产品 */}
        {categoryList?.[currentIndex]?.bannerName?.includes('产品') && (
          <HomeTabView04 />
        )}
        {/* 设备租赁 */}
        {categoryList?.[currentIndex]?.bannerName?.includes('租赁') && (
          <HomeTabView05 />
        )}
      </div>
    </HomeTabWrap>
  );
};

export default HomeTabView;
export const HomeTabWrap = styled.div`
  position: relative;
  width: 68%;
  min-height: 30rem;
  //background: lightblue;
  .tab-sub {
    position: absolute;
    top: 3.28rem;
    left: -9rem;
    //position: fixed;
    //top: 20rem;
    //left: 1.5rem;
    width: 4.44rem;
    min-height: 4.44rem;
    background: rgba(203, 203, 203, 0.35);
    z-index: 100;
    .tab-item {
      position: relative;
      width: 4.44rem;
      height: 4.44rem;
      &:not(:last-child) {
        margin-bottom: 0.52rem;
      }
      &:hover {
        background: rgba(203, 203, 203, 0.35);
      }
      .image {
        width: 3.33rem;
        height: 2.08rem;
        object-fit: cover;
      }
      .title {
        font-weight: 400;
        font-size: 0.78rem;
        color: #333333;
        line-height: 1.11rem;
      }
    }
    .item-active {
      background: rgba(203, 203, 203, 0.35);
    }
  }
`;
