import React, { useEffect, useState } from 'react';
import { RightOutlined } from '@ant-design/icons';
import { useSelector } from 'react-redux';
import styled from 'styled-components';
import { HomeAPI } from '@/api';
import { InterListType, InterReqType } from '@/api/interface';
import { ForumListType } from '@/api/interface/home';
import ForumItemView from '@/components/forumItem';
import ProductListView from '@/components/productList';
import HomeProductView from '@/pages/home/comp/home-product/_index';
import { RootState } from '@/store';
import { SystemState } from '@/store/module/system';

// 列表类型
type ListType = InterListType<ForumListType>;
// 请求类型
type ReqType = InterReqType<ForumListType>;

const HomeForumView = () => {
  // system
  const system = useSelector((state: RootState) => state.system) as SystemState;
  // 论坛列表
  const [forumList, setForumList] = useState<ListType>([]);
  // 分页数据
  const [pagination, setPagination] = useState({
    pageNo: 1,
    pageSize: 5,
    totalCount: 0,
  });
  // 获取论坛列表
  const getForumList = async (data: ReqType) => {
    const res = await HomeAPI[system?.token ? 'getForumList' : 'getForumList1'](
      {
        pageNo: pagination.pageNo,
        pageSize: pagination.pageSize,
        ...data,
      },
    );
    if (res && res.code === '200') {
      const { list, totalCount, pageNo, pageSize } = res.result || {};
      setForumList(list || []);
      setPagination({ pageNo, pageSize, totalCount });
    }
  };
  // 翻页回调
  const handlePageChange = async (pageNo: number, pageSize: number) => {
    await getForumList({ pageNo, pageSize });
  };
  // 页面挂载
  useEffect(() => {
    getForumList({}).then();
  }, []);
  return (
    <HomeForumWrap>
      <div className="forum-head flex-between">
        <div className="label">飞友圈</div>
        <div className="action flex-end">
          <div className="text">更多</div>
          <RightOutlined />
        </div>
      </div>
      <div className="forum-list">
        {/* 论坛列表 */}
        <ProductListView
          pagination={pagination}
          showSizeChanger={false}
          showTotal={false}
          position={'bottom-left'}
          onChange={handlePageChange}
        >
          {pagination?.pageNo === 1 ? (
            <>
              {forumList
                ?.slice(0, 1)
                ?.map((i, j) => <ForumItemView key={j} detail={i} />)}
              {/* 大家都在买 */}
              <HomeProductView />
              {forumList
                ?.slice(1)
                ?.map((i, j) => <ForumItemView key={j} detail={i} />)}
            </>
          ) : (
            forumList?.map((i, j) => <ForumItemView key={j} detail={i} />)
          )}
        </ProductListView>
      </div>
    </HomeForumWrap>
  );
};

export default HomeForumView;
// 样式
const HomeForumWrap = styled.div`
  position: relative;
  width: 68%;
  margin-bottom: 2rem;
  //min-height: 10rem;
  //background: lightblue;
  .forum-head {
    position: relative;
    width: 100%;
    box-sizing: border-box;
    margin-bottom: 1rem;
    .label {
      font-weight: 550;
      font-size: 1rem;
      color: #333333;
      user-select: none;
    }
    .action {
      display: none;
      color: #ff552d;
    }
  }
  .forum-list {
    position: relative;
    width: 100%;
    box-sizing: border-box;
  }
`;
