import React, { useEffect, useState } from 'react';
import { useRouter } from 'next/router';
import styled from 'styled-components';
import { HomeAPI } from '@/api';
import { InterListType } from '@/api/interface';
import { ListCompanyInfoByCoopIdType } from '@/api/interface/home';

// 列表类型
type ListType = InterListType<ListCompanyInfoByCoopIdType>;

const HomeBrandView: React.FC = () => {
  // 路由钩子
  const router = useRouter();
  // 店铺列表
  const [companyList, setCompanyList] = useState<ListType>([]);
  // 获取店铺列表
  const getListCompanyInfo = async () => {
    const res = await HomeAPI.listCompanyInfoByCoopId({
      lat: 30.04885,
      lon: 119.96043,
      pageNo: 1,
      pageSize: 999,
      coopId: 5,
    });
    if (res && res.code === '200') {
      const list = res.result?.list || [];
      const kbt = list.filter((i) => i.companyName.includes('科比特'));
      const other = list.filter((i) => !i.companyName.includes('科比特'));
      setCompanyList([...kbt, ...other]?.slice(0, 7));
      // console.log('获取网点数据 --->', companyList.value)
    }
  };
  // 跳转列表
  const handleList = async () => {
    await router.push('/store/product');
  };
  // 跳转详情
  const handleDetail = async (item: ListType[0]) => {
    await router.push(`/store/product/${item?.backUserAccountId}`);
  };
  // 组件挂载
  useEffect(() => {
    getListCompanyInfo().then();
  }, []);
  return (
    <HomeBrandWrap>
      <div className="brand-label flex-center">
        <div className="title select-none">优秀服务商</div>
        <div className="action cursor-pointer" onClick={handleList}>
          查看更多
        </div>
      </div>
      <div className="brand-list flex-start">
        {companyList?.map((i, j) => (
          <div
            className="flex-center list-item cursor-pointer list-none"
            key={j}
            onClick={() => handleDetail(i)}
          >
            <img
              className="image"
              src={`${
                i?.brandLogo || i?.backImg
              }?x-oss-process=image/quality,q_10`}
              alt={i?.brandName || i?.companyName}
            />
          </div>
        ))}
      </div>
    </HomeBrandWrap>
  );
};

export default HomeBrandView;
const HomeBrandWrap = styled.div`
  position: relative;
  width: 100%;
  height: 10.89rem;
  background: linear-gradient(
    180deg,
    rgba(220, 234, 255, 1) 0%,
    rgba(220, 234, 255, 0.3) 100%
  );
  box-sizing: border-box;
  display: flex;
  justify-content: flex-start;
  align-items: center;
  padding: 0 0 0 1.5rem;
  margin: 0.25rem 0 1rem 0;
  .brand-label {
    position: relative;
    box-sizing: border-box;
    flex-direction: column;
    margin-right: 1.5rem;
    .title {
      font-weight: bold;
      font-size: 1.5rem;
      color: #333333;
      line-height: 2.08rem;
      text-align: center;
      margin-bottom: 1.25rem;
    }
    .action {
      width: 6.8rem;
      height: 2.2rem;
      background: #3d8bff;
      text-align: center;
      line-height: 2.2rem;
      color: #fff;
      &:hover {
        filter: brightness(0.96);
      }
    }
  }
  .brand-list {
    position: relative;
    box-sizing: border-box;
    .list-item {
      position: relative;
      width: 7.56rem;
      height: 7.56rem;
      background: #ffffff;
      &:hover {
        filter: brightness(0.96);
      }
      &:not(:last-child) {
        margin-right: 1rem;
      }
      .image {
        width: 86%;
        height: 86%;
        object-fit: cover;
      }
    }
  }
`;
