import React, { useEffect, useState } from 'react';
import { Affix } from 'antd';
import styled from 'styled-components';
import { HomeAPI } from '@/api';
import { InterListType, PaginationProps } from '@/api/interface';
import { ForumListType } from '@/api/interface/home';
import ForumItemView from '@/components/forumItem';

// 列表类型
type ListType = InterListType<ForumListType>;

const DetailForumList = () => {
  // 翻页数据
  const [pagination, setPagination] = useState<
    { totalPage: number } & PaginationProps
  >({
    pageNo: 1,
    pageSize: 5,
    totalPage: 0,
  });
  // 论坛列表
  const [forumList, setForumList] = useState<ListType>([]);
  // 获取论坛列表
  const getForumList = async () => {
    const res = await HomeAPI.getForumList({
      pageNo: pagination.pageNo,
      pageSize: pagination.pageSize,
    });
    if (res && res.code === '200') {
      const { list, totalPage, pageNo, pageSize } = res.result || {};
      setForumList((prevList) => [...prevList, ...(list || [])]);
      pagination.totalPage = totalPage;
      setPagination({ pageNo, pageSize, totalPage });
    }
  };
  // 组件挂载
  useEffect(() => {
    getForumList().then();
  }, []);
  return (
    <Affix offsetTop={58}>
      <DetailForumWrap>
        <div className="mb-4 text-base font-bold">最新动态</div>
        <div className="list scroll-view w-full">
          {forumList?.map((i, j) => (
            <ForumItemView key={j} detail={i} hiddenMedia={true} />
          ))}
        </div>
      </DetailForumWrap>
    </Affix>
  );
};

export default DetailForumList;
// 样式
const DetailForumWrap = styled.div`
  position: relative;
  width: 100%;
  box-sizing: border-box;
  .list {
    position: relative;
    box-sizing: border-box;
    height: 70vh;
    overflow: hidden;
    overflow-y: scroll;
  }
`;
