import styled from 'styled-components';

export const HeaderWrap = styled.div`
  position: fixed;
  top: 0;
  left: 0;
  z-index: 100;
  width: 100%;
  height: 3rem;
  -webkit-backdrop-filter: saturate(68%) blur(16px);
  backdrop-filter: saturate(68%) blur(16px);
  background: rgba(86, 86, 86, 0.25);
  .header-wrap {
    position: relative;
    max-width: 1190px;
    height: 100%;
    box-sizing: border-box;
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin: 0 auto;
  }
  //padding: 0 12rem;
  .header-location {
    position: relative;
    display: flex;
    align-items: center;
    justify-content: flex-start;
    .location-icon {
      margin: 0 0.5rem 0 0;
    }
    .location-address,
    .location-hello {
      font-size: 12px;
      font-weight: 400;
      color: #ffffff;
    }
    .location-hello {
      min-width: 6.8rem;
    }
    .location-address {
      margin: 0 0.25rem 0 0 !important;
    }
    .location-reload,
    .location-address {
      width: auto;
      margin: 0 0.5rem 0 0;
      padding: 0;
    }
  }
  .header-nav {
    display: flex;
    align-items: center;
    justify-content: flex-end;
    .nav-action,
    .nav-tab {
      display: flex;
      align-items: center;
      justify-content: flex-end;
    }
    .nav-tab {
      margin-right: 0.5rem;
      .tab-item {
        //font-size: 0.67rem;
        font-weight: 500;
        color: #ffffff;
        margin-left: 1rem;
      }
      .tab-item:active,
      .tab-item:hover {
        color: #ff552d;
      }
    }
    .nav-action {
      margin-left: 0.5rem;
      .action-item {
        margin-left: 0.33rem;
      }
    }
    .nav-user {
      .user-avatar {
        width: 2rem;
        height: 2rem;
        border-radius: 50%;
        //background: #cdcdcd;
        border: 1px solid #ffffff;
        background-size: cover;
        background-position: center;
        &:active,
        &:hover {
          filter: brightness(0.9);
        }
      }
    }
  }
  // 媒体查询
  @media screen and (min-width: 1600px) {
    padding: 0 20rem;
  }
`;
