import React, { useEffect, useState } from 'react';
import { Button } from 'antd';
import styled from 'styled-components';
import { HomeAPI } from '@/api';
import { InterListType } from '@/api/interface';
import { AppListPilotType } from '@/api/interface/home';

// 列表类型
type ListType = InterListType<AppListPilotType>;

const HomeFlyerView = () => {
  // 飞手列表
  const [flyerList, setFlyerList] = useState<ListType>();
  // 获取飞手列表
  const getFlyerList = async () => {
    const res = await HomeAPI.appListPilot({
      // 审批通过
      auditStatus: 1,
      pageNo: 1,
      pageSize: 20,
    });
    if (res && res.code === '200') {
      const list = res.result?.list || [];
      setFlyerList(
        Array.from(
          { length: list.length < 5 ? list.length : 5 },
          () => list.splice(Math.floor(Math.random() * list.length), 1)[0],
        ),
      );
      // console.log('获取飞手列表 --->', flyerList.value)
    }
  };
  // 组件挂载
  useEffect(() => {
    getFlyerList().then();
  }, []);
  return (
    <HomeFlyerWrap>
      {flyerList?.map((i, j) => (
        <div className="flyer-item" key={j}>
          <img
            className="mb-2 h-12 w-12 rounded-full"
            src={i?.userImg}
            alt={i?.userName}
          />
          <div className="mb-2 font-bold">{i?.userName}</div>
          <div className="mb-2 text-aaa">
            <span className="mr-2">{i.residentCity}</span>
            <span>{i.yearsOfWorking}年经验</span>
          </div>
          <Button type="primary" shape="round">
            关注
          </Button>
        </div>
      ))}
    </HomeFlyerWrap>
  );
};

export default HomeFlyerView;
// 样式
const HomeFlyerWrap = styled.div`
  position: relative;
  width: 100%;
  display: flex;
  justify-content: flex-start;
  align-items: center;
  margin-bottom: 2rem;
  .flyer-item {
    position: relative;
    width: calc((100% - 4rem) / 5);
    height: 10rem;
    box-shadow: 0 0.17rem 0.86rem 0 rgba(65, 65, 65, 0.08);
    border-radius: 0.33rem;
    margin-right: 1rem;
    background: #ffffff;
    //background: lightblue;
    box-sizing: border-box;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-direction: column;
    &:last-child {
      margin-right: 0;
    }
  }
`;
