import React, { useEffect, useState } from 'react';
import { FlyerAPI } from '@/api';
import { InterListType } from '@/api/interface';
import { queryCurriculumInfoListType } from '@/api/interface/flyer';

// 列表类型
type ListType = InterListType<queryCurriculumInfoListType>;
// 课程类型列表
const courseAttributeList: { label: string; value: number; color: string }[] = [
  { label: '免费', value: 0, color: 'bg-[#f99a0b]' },
  { label: '积分', value: 1, color: 'bg-[#00AD53]' },
  { label: '付费', value: 2, color: 'bg-[#FF4600]' },
];

const HomeCourseView = () => {
  // 课程列表
  const [courseList, setCourseList] = useState<ListType>([]);
  // 获取热门课程
  const getCurriculumInfoList = async () => {
    const res = await FlyerAPI.queryCurriculumInfoList({
      pageSize: 5,
      pageNo: 1,
      isHot: 1,
    });
    if (res && res.code === '200') {
      const list = res.result?.list || [];
      setCourseList(list);
    }
  };
  // 获取当前课程属性
  const getCourseAttribute = (item: ListType[0]) => {
    return courseAttributeList?.find((i) => i.value === item?.courseAttribute);
  };
  // 组件挂载
  useEffect(() => {
    getCurriculumInfoList().then();
  }, []);
  return (
    <div className="mb-3 mt-3 flex w-full flex-nowrap items-center justify-start">
      {courseList?.map((i, j) => (
        <div
          className="animate__animated animate__fast animate__fadeIn relative  mr-3.5 w-1/5 cursor-pointer overflow-hidden rounded [box-shadow:0rem_0.17rem_0.86rem_0rem_rgba(65,65,65,0.08)] last:mr-0 hover:brightness-95 hover:filter"
          key={j}
        >
          {!!i.surfaceUrl && (
            <img
              src={i.surfaceUrl}
              alt={i.curriculumName}
              className="h-28 w-full object-cover"
            />
          )}
          <div className="box-border min-h-20 w-full bg-white px-2 pt-1">
            <div className="mb-1 flex">
              <div className="text-ellipsis font-bold text-333">
                {i.curriculumName}
              </div>
              <div
                className={`${getCourseAttribute(i)
                  ?.color} ml-2 min-w-8 rounded px-1 text-center text-xs text-white`}
              >
                {getCourseAttribute(i)?.label}
              </div>
            </div>
            <div className="text-ellipsis text-xs text-777">
              {i.curriculumDesc}
            </div>
            <div className="absolute bottom-1 right-0 flex w-full justify-between px-2 text-xs text-aaa">
              <div>课程供应商</div>
              <div>{i.id * 333} 人已学习</div>
            </div>
          </div>
        </div>
      ))}
    </div>
  );
};

export default HomeCourseView;
