import {
  MallOrderListType,
  UavOrderDetailType,
  UavOrderStatusListType,
} from '@/api/interface/order';
import request from '@/api/request';

export class OrderAPI {
  // 商城订单-列表（新）
  static getMallOrderList: MallOrderListType = (data) =>
    request.post('/oms/uav-order/listByUid', data);

  // 订单流程字典
  static uavOrderStatusList: UavOrderStatusListType = (params) =>
    request.get('/oms/uav-order/statusList', params);

  // 订单详情
  static uavOrderDetail: UavOrderDetailType = (params) =>
    request.get('/oms/uav-order/detail', { params });
}
