import {
  QueryGoodsInfoByCategorySub,
  GetAppCategoryInfo,
  AppMallGoodsDetails,
  GetCompanyInfoByBUId,
  LeaseGoodsDetailsType,
  LeaseTermInfoType,
  ListCompanyInfoByCoopIdType,
  BrandStoreListType,
  QueryBrandGoodsType,
} from '@/api/interface/mall';
import request from '../request';

export class MallAPI {
  // 小程序分类信息--含一二级分类
  static getAppCategoryInfo: GetAppCategoryInfo = (params) =>
    request.get('/pms/category/appCategoryInfo', { params });

  // 根据子分类查询商品信息
  static queryGoodsInfoByCategorySub: QueryGoodsInfoByCategorySub = (params) =>
    request.post('/pms/app/goods/queryGoodsInfoByCategorySub', params);

  // 小程序商品详情
  static appMallGoodsDetails: AppMallGoodsDetails = (params) =>
    request.get('/pms/app/goods/appMallGoodsDetails', { params });

  // pc-后台用户id单位查询
  static getCompanyInfoByBUId: GetCompanyInfoByBUId = (params, config) =>
    request.get('/userapp/company/getCompanyInfoByBUId', { params, ...config });

  // 租赁商品详情
  static leaseGoodsDetails: LeaseGoodsDetailsType = (params) =>
    request.get('/pms/app/lease/leaseGoodsDetails', { params });

  //  租赁-商品-租期信息
  static getLeaseTermInfo: LeaseTermInfoType = () =>
    request.post('/pms/lease/goods/getLeaseTermInfo');

  // 合作商家列表-根据合作标签id获取
  static listCompanyInfoByCoopId: ListCompanyInfoByCoopIdType = (params) =>
    request.get('/userapp/cooperation/listCompanyInfoByCoopId', { params });

  // 品牌店铺列表
  static brandStoreList: BrandStoreListType = (params) =>
    request.post('/pms/app/goods/brandStoreList', params);

  // 查询品牌方的商品
  static queryBrandGoods: QueryBrandGoodsType = (params) =>
    request.get('/pms/app/goods/queryBrandGoods', { params });
}
