import { InterFunction, InterListFunction } from '@/api/interface';

// 所有课程分类列表
export type SelectCurriculumClassifyType = InterFunction<
  {},
  {
    classifyDesc: string;
    classifyUrl: string;
    createTime: string;
    id: number;
    name: string;
    oneCourseId: number;
    twoCourseId: number;
    updateTime: string;
  }[]
>;
// V1.0.1课程视频列表
export type QueryCurriculumInfoListType = InterListFunction<
  {
    courseAttribute?: number;
    curriculumName?: string;
    oneCourseId?: number;
    twoCourseId?: number;
    isHot?: number;
  },
  {
    id: number;
    oneCourseId: number;
    twoCourseId: number;
    curriculumName: string;
    curriculumDesc: string;
    surfaceUrl: string;
    videoUrl: string;
    courseAttribute: number;
    requireAmout: number;
    requireIntegral: number;
    isHot: number;
    detailContent: string;
    createTime: string;
    updateTime: string;
  }
>;
// 课程详情
export type CourseDetailType = InterFunction<
  { id: string },
  {
    id: number;
    oneCourseId: number;
    twoCourseId: number;
    curriculumName: string;
    curriculumDesc: string;
    surfaceUrl: string;
    videoUrl: string;
    courseAttribute: number;
    requireAmout: number;
    requireIntegral: number;
    isHot: number;
    detailContent: null;
    createTime: string;
    updateTime: string;
    buy: boolean;
  }
>;
