import React, { Component, useEffect } from 'react';
import {Box} from './styled';
export default function MapComponent() {
    let map 
    const init =async ()=>{
        try {
         const AMapLoader = await import(/* webpackChunkName: "amap" */ '@amap/amap-jsapi-loader');
         AMapLoader.load({
             key: '87b424e68754efc3ba9d11ae07475091', // 申请好的Web端开发者Key，首次调用 load 时必填
             version: '2.0', // 指定要加载的 JSAPI 的版本，缺省时默认为 1.4.15
             plugins: [''], // 需要使用的的插件列表，如比例尺'AMap.Scale'等
           })
             .then(AMap => {
               map = new AMap.Map('container', {
                 // 设置地图容器id
                 viewMode: '3D', // 是否为3D地图模式
                 zoom: 11, // 初始化地图级别
                 center: [113.93029,22.53291], // 初始化地图中心点位置
               });
             })
             .catch(e => {
               console.log(e);
             });
        } catch (error) {
         console.log(error);
        }
     }
    useEffect(()=>{
        init()
    },[])
    return (
      <Box className='right-box-item'>
        <div id="container" className="map" ></div>
        <div className='map-dosome'>
          <div>服务网点</div>
          <div>租赁网点</div>
          <div>培训网点</div>
          <div>更多网点</div>
        </div>
      </Box>
    )
  }