import request, { Response } from '~/api/request';

export interface FilterOptionResp {
  id: number,
  name: string
}

export interface RegionResp {
  "childInfo": RegionResp[] | null,
  "id": number,
  "level": number,
  "name": string,
  "pid": number
}

export default {
  category: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webProductMall/category');
  },
  brand: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webDevice/brand');
  },
  model: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webDevice/model');
  },
  part: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webProductMall/parts');
  },
  quality: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webProductMall/quality');
  },
  region: (): Promise<Response<Array<RegionResp>>> => {
    return request('/pms/webDevice/getSecondDistrictInfo');
  },
}