
import config from './config';
/**
 * 请求封装
 * @param url 请求url
 * @param method 请求方法类型
 * @param data 请求的参数
 * @returns Promise<Response>
 */
export default function request(url: string, method: String = 'get', data?: any): Promise<Response<any>> {
  let options = {};

  switch (method.toLowerCase()) {
    case 'get':
      let params = new URLSearchParams();
      if (data) {
        Object.keys(data).forEach((key) => {
          params.append(key, data[key]);
        })

        url += '?' + params;
      }
      break;

    case 'post':
      options = {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json'
        },
        body: JSON.stringify(data)
      }
      break;
  }

  return fetch(config.baseUrl + url, options)
    .then((r) => {
      try{
        return r.json()
      }catch(e){
        console.error(e);
      }
      return {
        code: '-1',
        message: '请求失败',
        result: null
      }
    })
    .then((data) => {
      return data;
    });
}

//准备响应结构
export interface Response<T> {
  code: string,
  message: string,
  result: T
}