import request, { Response } from '~/api/request';
import { Item } from '~/pages/projectInfo/components/news/api';

export interface DetailsParams {
  tenderNewsId: number;
  pageNo: number;
  pageSize: number;
}
export interface DetailsResp {
  id: number;
  tenderTitle?: string;
  tenderPrice?: number;
  tenderContent?: string;
  createTime?: string;
}
export interface ListTenderPageResp {
  pageNo: number;
  pageSize: number;
  list: DetailsResp[];
  totalCount: number;
  totalPage: number;
}

export default {
  //招标详情
  details(params: DetailsParams): Promise<Response<ListTenderPageResp>> {
    return request('/release/tender/info', 'get', params);
  },
};
