import React from 'react';
import { Pagination } from 'antd';
import styled from 'styled-components';

// 样式
const ProductListWrap = styled.div`
  position: relative;
  width: 100%;
  .mall-list {
    position: relative;
    width: 100%;
    min-height: 60vh;
    flex-wrap: wrap;
    align-items: flex-start;
    align-content: flex-start;
  }
  .list-empty {
    position: relative;
    width: 100%;
    height: 60vh;
  }
  .mall-pagination {
    position: relative;
    width: 100%;
    height: 4rem;
    box-sizing: border-box;
    margin-bottom: 1rem;
  }
`;

// 分页数据类型
type PaginationProps = {
  pageNo: number;
  pageSize: number;
  totalCount: number;
};

const ProductListView: React.FC<{
  children: React.ReactNode;
  pagination: PaginationProps;
  onChange: (pageNo: number, pageSize: number) => void;
  showSizeChanger?: boolean;
  showTotal?: boolean;
  position?: 'bottom-right' | 'bottom-left';
}> = ({
  children,
  pagination,
  onChange,
  showSizeChanger = true,
  showTotal = true,
  position = 'bottom-right',
}) => {
  return (
    <ProductListWrap>
      <div className="mall-list flex-start">{children}</div>
      <div
        className={`mall-pagination ${
          position === 'bottom-right' ? 'flex-end' : 'flex-start'
        }`}
      >
        <Pagination
          showSizeChanger={showSizeChanger}
          onChange={onChange}
          defaultPageSize={pagination.pageSize}
          current={pagination.pageNo}
          total={pagination.totalCount}
          showTotal={showTotal ? (total) => `共 ${total} 条` : undefined}
          pageSizeOptions={['6', '12', '18', '36', '72']}
        />
      </div>
    </ProductListWrap>
  );
};

export default ProductListView;
