import React, { useState } from 'react';
import styled from 'styled-components';
import {
  FreeMode,
  Navigation,
  Thumbs,
  Autoplay,
  Mousewheel,
} from 'swiper/modules';
import { Swiper, SwiperSlide } from 'swiper/react';
import 'swiper/css';
import 'swiper/css/free-mode';
import 'swiper/css/navigation';
import 'swiper/css/thumbs';

const ProductSwiperWrap = styled.div`
  position: relative;
  width: 200%;
  height: 200%;
  box-sizing: border-box;
  transform: scale(0.5) translateX(-50%) translateY(-50%);
  .swiper-main {
    position: relative;
    width: 100%;
    height: calc(100% - 9rem);
    margin-bottom: 0.5rem;
    .swiper-slide {
      img {
        width: 100%;
        height: 100%;
        object-fit: cover;
      }
    }
  }
  .swiper-second {
    position: relative;
    width: 100%;
    height: 9rem;
    .swiper-slide {
      img {
        width: 100%;
        height: 100%;
        object-fit: contain;
      }
    }
  }
`;

const ProductSwiperView: React.FC<{
  list: { id: number; url: string }[];
}> = ({ list }) => {
  const [thumbsSwiper, setThumbsSwiper] = useState(null);
  // 图片列表
  const SwiperListArr = list?.map((i, j) => (
    <SwiperSlide key={j}>
      <img src={i.url} alt={'图片'} />
    </SwiperSlide>
  ));
  return (
    <ProductSwiperWrap>
      <Swiper
        className="swiper-main"
        style={
          {
            '--swiper-navigation-color': '#fff',
            '--swiper-pagination-color': '#fff',
          } as any
        }
        loop={true}
        // spaceBetween={10}
        navigation={true}
        thumbs={{ swiper: thumbsSwiper }}
        modules={[FreeMode, Navigation, Thumbs, Autoplay, Mousewheel]}
        autoplay={{
          delay: 5000,
        }}
        mousewheel={true}
        grabCursor={true}
      >
        {SwiperListArr}
      </Swiper>
      <Swiper
        className="swiper-second"
        // @ts-ignore
        onSwiper={setThumbsSwiper}
        loop={true}
        spaceBetween={10}
        slidesPerView={list?.length > 5 ? 5 : list?.length}
        slidesPerGroupAuto={true}
        freeMode={true}
        watchSlidesProgress={true}
        modules={[FreeMode, Navigation, Thumbs]}
        grabCursor={true}
      >
        {SwiperListArr}
      </Swiper>
    </ProductSwiperWrap>
  );
};

export default ProductSwiperView;
