import React from "react";
import { Carousel } from "antd";
import { Box } from "./styled";
import Image from "next/image";

export default function RotationChart() {
  const list = [
    "https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/1(1).jpg",
    "https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/2(1).jpg",
    "https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/3(1).jpg",
    "https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/4(1).jpg",
    "https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/5(1).jpg"
  ];
  return (
    <Box>
      <Carousel
        className="rotationChart"
        autoplay
        dots={{ className: "botsBotton" }}
      >
        {list.map((item) => (
          <div key={item}>
            <h3 className="contentStyle">
              <Image src={item} alt="error" fill />
            </h3>
          </div>
        ))}
      </Carousel>
    </Box>
  );
}
