import React, { useEffect } from "react";
import { Empty } from "antd";
import { LeftBox , Box , WaterfallBox } from "./styled";
import { leftBoxProps } from "../interface";

export default function Left(props: leftBoxProps) {
  const { boxIndex, leftRenderDom, leftcontentstyle, leftWaterfallDom } = props; 
  return (
    <LeftBox>
      {leftRenderDom?.columns.map((item) => {
        if (item.noFor) {
          return item.element;
        }
        return null;
      })}
      {
        <Box index={boxIndex} leftcontentstyle={leftcontentstyle}>
          {leftRenderDom?.columns.map((item) => {
            if (!item.noFor) {
              return item.element;
            }
            return null;
          })}
        </Box>
      }
      {leftWaterfallDom?.columns.map((item) => {
        if (item.noFor) {
          return item.element;
        }
        return null;
      })}
      {
        leftWaterfallDom?.columns.length ? <WaterfallBox index={boxIndex} leftcontentstyle={leftcontentstyle}>
        { <div className="left-columns">
            {leftWaterfallDom?.columns.map((item) => {
            if (!item.noFor && item.type === "left") {
                return item.element
            }
            return null
          })}
        </div>}
        { <div className="right-columns">
            {leftWaterfallDom?.columns.map((item) => {
            if (!item.noFor && item.type === "right") {
                return item.element
            }
            return null
          })}
        </div>}
      </WaterfallBox> : null
      }
      {leftRenderDom?.pagination ? leftRenderDom?.pagination : null}
      {!leftRenderDom?.columns.length && !leftWaterfallDom?.columns.length? (
        <Empty description={"暂无数据"} />
      ) : null}
    </LeftBox>
  );
}
