// @ts-nocheck
/* eslint-disable */

import Big from "big.js";
import {isNone} from "@/utils/index";

export const formatCurrency = (s, n) => {
  n = n > 0 && n <= 20 ? n : 2
  s = `${parseFloat(`${s}`.replace(/[^\d\.-]/g, '')).toFixed(n)}`
  const l = s.split('.')[0].split('').reverse()
  const r = s.split('.')[1]
  let t = ''
  for (let i = 0; i < l.length; i++) {
    t += l[i] + ((i + 1) % 3 == 0 && i + 1 != l.length ? ',' : '')
  }
  return t.split('').reverse().join('')
}
// 格式化千分位并补零
export const moneyFormat = (num) => {
  if (Number(num).toString() !== 'NaN') {
    // 添加千分符
    let _n = Number(num).toLocaleString()
    if (_n.indexOf('.') !== -1) {
      _n = `${_n}00`
    } else {
      _n = `${_n}.00`
    }
    // 因为有千分符所以，返回数据为字符串格式，无法做运算操作，适合做直接显示使用
    return _n.substring(0, _n.indexOf('.') + 3)
  }
  // console.log('参数格式有误')
}
// 金额大数字转换
export const bigNumberTransform = (value, type) => {
  const newValue = ['', '', ''];
  let fr = new Big(1000);
  let num = 3;
  let text1 = '';
  let text2 = '';
  let fm = new Big(1);
  if (value === '' || value === null || isNaN(value)) {
    return !type ? newValue : '';
  }
  value = new Big(value);
  if (value.lt(0)) {
    value = value.abs();
    text2 = '-';
  }
  while (value.div(fr).gte(1)) {
    fr = fr.times(10);
    num += 1;
  }
  if (num <= 4) {
    // 千
    newValue[0] = value.toString();
    newValue[1] = '';
  } else if (num <= 8) {
    // 万
    text1 = '万';
    fm = text1 === '万' ? new Big(10000) : new Big(10000000);
    if (value.mod(fm).eq(0)) {
      newValue[0] = `${value.div(fm).round()}`;
    } else {
      newValue[0] = `${value.div(fm).round(2, 0)}`;
    }
    newValue[1] = text1;
  } else {
    // 亿
    text1 = '亿';
    text1 = (num - 8) / 4 > 1 ? '万亿' : text1;
    text1 = (num - 8) / 7 > 1 ? '千万亿' : text1;
    text1 = (num - 8) / 10 > 1 ? '亿亿' : text1;
    fm =
      text1 === '亿'
        ? new Big(100000000)
        : text1 === '千亿'
          ? new Big(100000000000)
          : text1 === '万亿'
            ? new Big(1000000000000)
            : text1 === '千万亿'
              ? new Big(1000000000000000)
              : new Big(1000000000000000000);
    if (value.mod(fm).eq(0)) {
      newValue[0] = `${value.div(fm).round()}`;
    } else {
      newValue[0] = `${value.div(fm).round(2, 0)}`;
    }
    newValue[1] = text1;
  }
  if (value.lt(1000)) {
    newValue[0] = `${value}`;
    newValue[1] = '';
  }
  newValue[0] = text2 ? text2 + newValue[0] : newValue[0];
  return !type ? Number(newValue).toFixed(2).toLocaleString() : Number(newValue[0]).toFixed(2).toLocaleString() + newValue[1];
};

// 格式化金额
export const formatMoney = (money) => {
  return !isNone(money) ? Big(money)?.toFixed(2)?.toLocaleString() : ''
}
