import React from 'react';
import { ConfigProvider, theme } from 'antd';
// eslint-disable-next-line import/order
import type { AppProps } from 'next/app';
import '../styles/animate.css';
import '../styles/globals.css';
import themeConfig from '../theme/themeConfig';

const App = ({ Component, pageProps }: AppProps) => (
  <ConfigProvider
    theme={{
      algorithm: theme.compactAlgorithm,
      ...themeConfig,
    }}
  >
    <Component {...pageProps} />
  </ConfigProvider>
);

export default App;
