import { TabsProps, Tabs } from "antd";
import {useRouter} from "next/router";
import { useEffect, useState } from "react";
import LayoutView from "~/components/layout";
import Sider from "../components/sider";
import styles from "./index.module.scss";

const onChange = (key: string) => {
  console.log(key);
};

const items: TabsProps["items"] = [
  {
    key: "1",
    label: `Tab 1`,
    children: `Content of Tab Pane 1`,
  },
  {
    key: "2",
    label: `Tab 2`,
    children: `Content of Tab Pane 2`,
  },
  {
    key: "3",
    label: `Tab 3`,
    children: `Content of Tab Pane 3`,
  },
];

export default function ServicesOrder() {
  const router = useRouter();

  return (
    <>
      <LayoutView
        layoutStyle={{ backgroundColor: "#fff" }}
        contentStyle={{ width: 1000, marginLeft: 526 }}
      >
        <Sider
          style={{
            position: "absolute",
            left: -37,
            transform: "translateX(-100%)",
          }}
          selectedKeys={[router.pathname]}
        ></Sider>
        <div>
          <div className={styles.font1}>服务订单</div>
          <Tabs defaultActiveKey="1" items={items} onChange={onChange} />
        </div>
      </LayoutView>
    </>
  );
}
