import LayoutView from "~/components/layout";
import React, { useState } from "react";
import type { MenuProps } from "antd";
import { Button, Menu } from "antd";
import styles from "./index.module.scss";
import Router from "next/router";

function getItem(
  label: React.ReactNode,
  key: React.Key,
  icon?: React.ReactNode,
  children?: MenuItem[],
  type?: "group"
): MenuItem {
  return {
    key,
    icon,
    children,
    label,
    type,
  } as MenuItem;
}

const items: MenuItem[] = [
  getItem("我的订单", "1", undefined, [
    getItem("服务订单", "/personalCenter/servicesOrders"),
    getItem("租赁订单", "1-1"),
    getItem("商城订单", "/personalCenter/mallOrders"),
    getItem("培训订单", "1-2"),
  ]),
  getItem("账户信息", "2"),
  getItem("优惠券卡包", "3"),
  getItem("福利活动", "4"),
  getItem("身份认证", "5"),
  getItem("客服中心", "6"),
  getItem("推广海报", "7"),
  getItem("副业赚钱", "8"),
];

type MenuItem = Required<MenuProps>["items"][number];

type Props = {
  style?: React.CSSProperties;
  selectedKeys?: string[];
};

export default function Sider(props: Props) {
  return (
    <div className={styles.Sider} style={props.style}>
      <div className={styles.title}>个人中心</div>
      <Menu
        selectedKeys={props.selectedKeys}
        openKeys={["1"]}
        mode="inline"
        items={items}
        className={styles.menu}
        onClick={(info) => {
          Router.push(info.key);
        }}
      />
    </div>
  );
}
