import styled from 'styled-components'

export const OrderForGoodsBox = styled.div`
  box-sizing: border-box;
  width: 1000px;
  .address {
    .top {
      display: flex;
      justify-content: space-between;
      align-items: center;
      border-bottom: 1px solid #e6e6e6;
      height: 30px;
      line-height: 30px;
      margin-top: 30px;
      .left {
        font-size: 14px;
        font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
        font-weight: bold;
        color: #333333;
        line-height: 18px;
      }
      .right {
        .btn {
          font-size: 14px;
          font-family: MicrosoftYaHei;
          color: #007aff;
          line-height: 19px;
        }
      }
    }
    .bottom {
      .item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        width: 1000px;
        height: 48px;
        border: 1px solid transparent;
        margin-top: 8px;
        &.active {
          background: #fff1e8;
          border-radius: 6px;
          border: 1px solid #ff552d;
        }
        .left {
          display: flex;
          align-items: center;
          justify-content: space-around;
          .active {
            margin-right: 18px;
            display: flex;
            .icon {
              width: 15px;
              height: 22px;
              background: #ff552d;
              margin-left: 17px;
            }
            .label {
              font-size: 14px;
              font-family: MicrosoftYaHei;
              color: #000000;
              line-height: 19px;
              margin-left: 18px;
            }
          }
        }
        .right {
          margin-right: 22px;
        }
      }
    }
  }
  .info {
    margin-top: 30px;
    .title {
      font-size: 14px;
      font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
      font-weight: bold;
      color: #333333;
      line-height: 18px;
    }
    .table {
      .table-title {
        display: flex;
        align-items: center;
        width: 1000px;
        border-bottom: 1px solid #e6e6e6;
        padding: 10px 0;
        margin-top: 20px;
        .table-item {
          text-align: center;
          font-size: 14px;
          font-family: MicrosoftYaHei;
          color: #000000;
          line-height: 19px;
        }
      }
      .table-body {
        display: flex;
        align-items: center;
        height: 100px;
        margin-top: 10px;
        .body-item {
          text-align: center;
          &.article {
            display: flex;
            justify-content: space-between;
            .image {
              width: 80px;
              height: 80px;
              background-color: pink;
              margin-right: 10px;
            }
            .right {
              .top {
                width: 171px;
                font-size: 14px;
                font-family: PingFangSC-Regular, PingFang SC;
                font-weight: 400;
                color: #141414;
                line-height: 20px;
              }
              .bottom {
                width: 171px;
                font-size: 12px;
                font-family: PingFangSC-Regular, PingFang SC;
                font-weight: 400;
                color: #929295;
                line-height: 17px;
              }
            }
          }
          &.lease-term {
            display: flex;
            align-items: center;
            justify-content: center;
            .num {
              width: 62px;
              height: 24px;
              background: #ff552d;
              border-radius: 2px;
              position: relative;
              margin: 0 15px;
              line-height: 24px;
              font-size: 14px;
              font-family: MicrosoftYaHei;
              color: #ffffff;
              &::before {
                content: '';
                width: 10px;
                height: 1px;
                background-color: #ff552d;
                position: absolute;
                left: -10px;
                top: 50%;
                transform: translateY(-50%);
              }
              &::after {
                content: '';
                width: 10px;
                height: 1px;
                background-color: #ff552d;
                position: absolute;
                right: -10px;
                top: 50%;
                transform: translateY(-50%);
              }
            }
          }
          &.total-price {
            font-size: 14px;
            font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
            font-weight: bold;
            color: #ff3100;
            line-height: 18px;
          }
        }
      }
    }
  }
  .notes {
    display: flex;
    align-items: center;
    justify-content: space-between;
    width: 1000px;
    height: 110px;
    background: #e1efff;
    border: 1px solid #d0eaf5;
    padding: 0 22px 0 16px;
    .left {
      display: flex;
      align-items: top;
      .label {
        font-size: 14px;
        font-family: MicrosoftYaHei;
        color: #000000;
        margin-top: 4px;
      }
    }
    .right {
      width: 430px;
      .top {
        display: flex;
        align-items: center;
        justify-content: space-between;
      }
      .font {
        display: flex;
      }
      .bottom {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-top: 18px;
      }
      .label {
        font-size: 14px;
        font-family: MicrosoftYaHei;
        color: #000000;
        line-height: 19px;
        margin-right: 12px;
      }
      .value {
        font-size: 14px;
        font-family: PingFangSC-Regular, PingFang SC;
        font-weight: 400;
        color: #2b2b2b;
        line-height: 20px;
      }
      .price {
        font-size: 14px;
        font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
        font-weight: bold;
        color: #ff3100;
        line-height: 18px;
      }
    }
  }
  .detail-box {
    display: flex;
    justify-content: flex-end;
    margin-top: 26px;
    .right-box {
      .detail {
        width: 477px;
        height: 110px;
        border: 1px solid #ff5001;
        padding: 16px 19px 19px 19px;
        .top {
          display: flex;
          justify-content: flex-end;
          align-items: center;
          .label {
            font-size: 14px;
            font-family: MicrosoftYaHei;
            color: #474747;
            line-height: 19px;
            margin-right: 10px;
          }
          .price {
            font-size: 26px;
            font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
            font-weight: bold;
            color: #ff552d;
            line-height: 33px;
          }
        }
        .bottom {
          display: flex;
          justify-content: flex-end;
          align-items: center;
          margin-top: 15px;
          .value {
            font-size: 12px;
            font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
            font-weight: bold;
            color: #000000;
            line-height: 15px;
            margin-right: 10px;
          }
          .value-content {
            font-size: 12px;
            font-family: MicrosoftYaHei;
            color: #333333;
            line-height: 16px;
          }
        }
      }
      .detail-sumbit {
        display: flex;
        justify-content: flex-end;
        .btn {
          width: 182px;
          height: 39px;
          background: #ff552d;
          border: 1px solid #ff5001;
          border-radius: 0;
          color: #ffffff;
        }
      }
    }
  }
`
