import React, { useState } from 'react'
import { OrderForGoodsBox } from './styled'
import type { RadioChangeEvent } from 'antd'
import { Button, Radio, Space, Input, message } from 'antd'
const { TextArea } = Input

interface PropsBox {
  setIsorderForGoods: (boolean: boolean) => void
}

export default function OrderForGoods(props: PropsBox) {
  const { setIsorderForGoods } = props
  const [value, setValue] = useState(1)
  const [areaValue, setAreaValue] = useState<string>()
  const [list, setList] = useState([{}, {}, {}, {}])
  const onChange = (e: RadioChangeEvent) => {
    console.log('radio checked', e.target.value)
    setValue(e.target.value)
  }
  const onChangeValue = (index: number) => {
    setValue(index)
  }
  const detailSumbit = () => {
    message.success('提交成功')
    setIsorderForGoods(false)
  }
  return (
    <OrderForGoodsBox>
      <div className="address">
        <div className="top">
          <div className="left">确认收货地址</div>
          <div className="right">
            <Button type="link" style={{ color: '#007aff' }}>
              管理收货地址
            </Button>
          </div>
        </div>
        <div className="bottom">
          {list.map((item, index) => (
            <div
              className={`item ${value === index ? 'active' : ''}`}
              onClick={() => onChangeValue(index)}
            >
              <div className="left">
                <div className="active">
                  <div className="icon"></div>
                  <div className="label">寄送至</div>
                </div>
                <Radio.Group onChange={onChange} value={value}>
                  <Space direction="vertical">
                    <Radio value={index}>
                      广东省深圳市南山区国际创谷6栋（黄晓敏收）
                    </Radio>
                  </Space>
                </Radio.Group>
              </div>
              {value === index ? (
                <div className="right">
                  <Button type="link" style={{ color: '#007aff' }}>
                    修改地址
                  </Button>
                </div>
              ) : null}
            </div>
          ))}
        </div>
      </div>
      <div className="info">
        <div className="title">确认订单信息</div>
        <div className="table">
          <div className="table-title">
            <div className="table-item" style={{ width: 290 }}>
              宝贝
            </div>
            <div className="table-item" style={{ width: 130 }}>
              单价
            </div>
            <div className="table-item" style={{ width: 130 }}>
              数量
            </div>
            <div className="table-item" style={{ width: 300 }}>
              租期
            </div>
            <div className="table-item" style={{ width: 135 }}>
              合计
            </div>
          </div>
          <div className="table-body">
            <div className="body-item article" style={{ width: 290 }}>
              <div className="image"></div>
              <div className="right">
                <div className="top">
                  智多星航电版智多星航电版智多星航电版智多
                </div>
                <div className="bottom">
                  商品简介商品简介商品简介商品简介商品简介
                </div>
              </div>
            </div>
            <div className="body-item" style={{ width: 130 }}>
              800.00/天
            </div>
            <div className="body-item" style={{ width: 130 }}>
              1
            </div>
            <div className="body-item lease-term" style={{ width: 300 }}>
              2023/05/10 <div className="num">4天</div> 2023/05/13
            </div>
            <div className="body-item total-price" style={{ width: 135 }}>
              800.00
            </div>
          </div>
        </div>
      </div>
      <div className="notes">
        <div className="left">
          <div className="label">备注：</div>
          <TextArea
            value={areaValue}
            onChange={(e) => setAreaValue(e.target.value)}
            placeholder="请输入备注"
            autoSize={{ minRows: 3, maxRows: 5 }}
            style={{ width: 385, height: 72 }}
          />
        </div>
        <div className="right">
          <div className="top">
            <div className="font">
              <div className="label">运费：</div>
              <div className="value">邮寄到付,由客户自己承担</div>
            </div>
            <div className="price">200.00</div>
          </div>
          <div className="bottom">
            <div className="font">
              <div className="label">押金：</div>
              <div className="value">渠道商可免押金</div>
            </div>
            <div className="price">1000.00</div>
          </div>
        </div>
      </div>
      <div className="detail-box">
        <div className="right-box">
          <div className="detail">
            <div className="top">
              <div className="label">实付款</div>
              <div className="price">¥20000.00</div>
            </div>
            <div className="bottom">
              <div className="value">寄送至</div>
              <div className="value-content">
                广东省深圳市南山区国际创谷6栋国际创谷6
              </div>
            </div>
          </div>
          <div className="detail-sumbit">
            <Button className="btn" onClick={detailSumbit}>
              提交订单
            </Button>
          </div>
        </div>
      </div>
    </OrderForGoodsBox>
  )
}
