import React, { useEffect, useState } from 'react';
import { Button } from 'antd';
import styled from 'styled-components';
import { HomeAPI } from '@/api';
import { InterListType } from '@/api/interface';
import { ListCompanyInfoByCoopIdType } from '@/api/interface/home';

// 列表类型
type ListType = InterListType<ListCompanyInfoByCoopIdType>;

const HomeBrandView = () => {
  // 店铺列表
  const [companyList, setCompanyList] = useState<ListType>([]);
  // 获取店铺列表
  const getListCompanyInfo = async () => {
    const res = await HomeAPI.listCompanyInfoByCoopId({
      lat: 30.04885,
      lon: 119.96043,
      pageNo: 1,
      pageSize: 999,
      coopId: 1,
    });
    if (res && res.code === '200') {
      const list = res.result?.list || [];
      const kbt = list.filter((i) => i.companyName.includes('科比特'));
      const other = list.filter((i) => !i.companyName.includes('科比特'));
      setCompanyList([...kbt, ...other]?.slice(0, 10));
      // console.log('获取网点数据 --->', companyList.value)
    }
  };
  // 组件挂载
  useEffect(() => {
    getListCompanyInfo().then();
  }, []);
  return (
    <HomeBrandWrap>
      <div className="brand-item">
        <div className="item-icon">
          <img
            src="/assets/image/home/home-brand-all.png"
            alt="全部品牌"
            className="image"
          />
        </div>
      </div>
      {companyList?.map((i, j) => (
        <div key={j} className="brand-item">
          <div className="item-logo">
            <img src={i.brandLogo} alt={i.brandName} className="image" />
          </div>
          <Button type={'link'} className="item-name text-ellipsis">
            {i.brandName || i.companyName}
          </Button>
        </div>
      ))}
    </HomeBrandWrap>
  );
};

// 样式
const HomeBrandWrap = styled.div`
  width: 100%;
  //min-height: 8.71rem;
  box-sizing: border-box;
  //background: aquamarine;
  padding: 1.33rem 0 0.83rem 0;
  display: flex;
  align-items: center;
  justify-content: flex-start;
  overflow-x: scroll;
  .brand-item {
    position: relative;
    width: 4rem;
    min-height: 6.3rem;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: flex-start;
    flex-direction: column;
    margin-right: 0.83rem;
    .item-icon,
    .item-logo {
      position: relative;
      width: 4rem;
      height: 4rem;
      border-radius: 50%;
      background: rgba(27, 27, 27, 0.13);
      .image {
        width: 100%;
        height: 100%;
      }
    }
    .item-logo {
      box-sizing: border-box;
      padding: 0.68rem;
      border: 0.04rem solid #e3e3e3;
      background: #fff;
      &:active,
      &:hover {
        filter: brightness(0.96);
      }
    }
    .item-name {
      width: 100%;
      font-size: 12px;
      font-weight: 400;
      color: #000000;
      text-align: center;
      margin-top: 0.58rem;
      padding: 0;
    }
  }
  &::-webkit-scrollbar-thumb {
    background: #d9d9d9;
    -webkit-border-radius: 2em;
    -moz-border-radius: 2em;
    border-radius: 2em;
    cursor: pointer;
  }
  &::-webkit-scrollbar {
    background-color: transparent;
    -webkit-border-radius: 2em;
    -moz-border-radius: 2em;
    border-radius: 2em;
    width: 7px;
    height: 7px;
  }
`;
export default HomeBrandView;
