import React from 'react';
import { Button, Rate } from 'antd';
import { useRouter } from 'next/router';
import { useDispatch } from 'react-redux';
import styled from 'styled-components';
import { InterDataType, InterListType } from '@/api/interface';
import {
  BrandStoreListType,
  ListCompanyInfoByCoopIdType,
} from '@/api/interface/mall';
import { setGlobalData } from '@/store/module/globalData';

// 详情类型
type DetailType = InterListType<ListCompanyInfoByCoopIdType>[0];
// 商品列表
type StoreType = InterDataType<BrandStoreListType>;

const StoreProductItem: React.FC<{
  detail: DetailType & { mallGoodsVOList: StoreType[0]['mallGoodsVOList'] };
}> = ({ detail }) => {
  // 路由钩子
  const router = useRouter();
  // store
  const dispatch = useDispatch();
  // 跳转商品
  const handleProductDetail = (data: StoreType[0]['mallGoodsVOList'][0]) => {
    dispatch(
      setGlobalData({
        loadingSpinnerVisible: true,
      }),
    );
    router.push(`/mall/product/${data?.id}`).then();
  };
  // 跳转详情
  const handleStoreDetail = async () => {
    await router.push(`/store/product/${detail?.backUserAccountId}`);
  };
  return (
    <StoreProductWrap>
      <div className="item-head cursor-pointer" onClick={handleStoreDetail}>
        <img
          src={`${
            detail?.brandLogo || detail?.backImg
          }?x-oss-process=image/quality,q_25`}
          alt={detail?.companyName}
          className="head-img"
        />
        <div className="head-content">
          <div className="name">{detail?.companyName}</div>
          <div className="star">
            <Rate
              disabled
              defaultValue={Number(detail?.score) || 4}
              className="text-xs text-primary"
            />
            <div className="type">无人机厂家</div>
          </div>
        </div>
        <Button type="primary" shape="round" className="head-action">
          进店
        </Button>
      </div>
      <div className="item-media flex w-3/4 flex-wrap items-start justify-start">
        {detail?.mallGoodsVOList?.length
          ? detail?.mallGoodsVOList?.map((i, j) => (
              <div
                className={'image'}
                key={j}
                onClick={() => handleProductDetail(i)}
              >
                <img
                  className={'img'}
                  src={`${i?.resourcesList?.find((v) => v.type === 0)
                    ?.url}?x-oss-process=image/quality,Q_50`}
                  alt="图片"
                />
              </div>
            ))
          : undefined}
      </div>
    </StoreProductWrap>
  );
};

export default StoreProductItem;
// 样式
const StoreProductWrap = styled.div`
  position: relative;
  width: 100%;
  box-sizing: border-box;
  border-bottom: 0.02rem solid #e3e3e3;
  padding: 1rem;
  .item-head {
    position: relative;
    width: 100%;
    box-sizing: border-box;
    display: flex;
    align-items: center;
    justify-content: flex-start;
    margin-bottom: 1rem;
    .head-img {
      width: 2.5rem;
      height: 2.5rem;
      border-radius: 50%;
      margin-right: 0.5rem;
    }
    .head-content {
      .name {
        color: #333;
        font-weight: bold;
        margin-bottom: 0.25rem;
      }
      .star {
        display: flex;
        align-items: center;
        justify-content: flex-start;
        .type {
          margin-left: 1rem;
          font-size: 10px;
          color: #999;
        }
      }
    }
    .head-action {
      position: absolute;
      top: 0;
      right: 0.5rem;
    }
  }
  .item-media {
    .image {
      width: calc((100% - 0.67rem * 3) / 4);
      height: 8.6rem;
      margin: 0 0.67rem 0.67rem 0;
      border-radius: 0.5rem;
      overflow: hidden;
      .img {
        width: 100%;
        height: 100%;
        object-fit: cover;
      }
      &:nth-child(4n) {
        margin-right: 0;
      }
    }
  }
`;
