import React from 'react';
import { PhoneOutlined, ShopOutlined } from '@ant-design/icons';
import { Button, Rate } from 'antd';
import styled from 'styled-components';
import { InterDataType } from '@/api/interface';
import {
  AppMallGoodsDetails,
  GetCompanyInfoByBUId,
} from '@/api/interface/mall';
import QrcodePopover from '@/components/qrcodePopover';
// 商品详情类型
type DetailType = InterDataType<AppMallGoodsDetails>;
// 商城详情类型
type StoreType = InterDataType<GetCompanyInfoByBUId>;
const ProductStoreView: React.FC<{ detail: DetailType; store: StoreType }> = ({
  store,
}) => {
  return (
    <ProductStoreWrap>
      <div className="store-card flex-start">
        <img
          className="image"
          src={store?.brandLogo}
          alt={store?.companyName}
        />
        <div className="card-content">
          <div className="title">{store?.companyName}</div>
          <div className="star flex-start">
            <div className="tag select-none">店铺星级</div>
            <Rate allowHalf defaultValue={5} style={{ fontSize: '10px' }} />
          </div>
          <div className="text two-line-ellipsis" title={store?.content}>
            {store?.content}
          </div>
        </div>
      </div>
      <div className="store-item flex-start">
        <div className="item-label">地址：</div>
        <div className="item-value">{store?.address}</div>
      </div>
      <div className="store-item flex-start">
        <div className="item-label">电话：</div>
        <div className="item-value">{store?.phoneNum || '18626051369'}</div>
      </div>
      <div className="store-action flex-start">
        <QrcodePopover
          path="page-service/service-store/index"
          scene={`id=${Number(store?.id)}`}
        >
          <Button className="action-item flex-start">
            <ShopOutlined style={{ color: '#FF552D' }} />
            <div className="text">进店逛逛</div>
          </Button>
        </QrcodePopover>
        <QrcodePopover
          path="page-service/service-store/index"
          scene={`id=${Number(store?.id)}`}
        >
          <Button className="action-item flex-start">
            <PhoneOutlined
              style={{ color: '#FF552D', transform: 'rotateY(180deg)' }}
            />
            <div className="text">联系方式</div>
          </Button>
        </QrcodePopover>
      </div>
    </ProductStoreWrap>
  );
};

export default ProductStoreView;

// 样式
const ProductStoreWrap = styled.div`
  position: relative;
  width: calc((100% - 0.83rem) / 10 * 2.5);
  min-height: 18rem;
  //height: 100%;
  background: #ffffff;
  border: 0.04rem solid #e3e3e3;
  box-sizing: border-box;
  padding: 1rem;
  .store-card {
    width: 100%;
    min-height: 8em;
    background: linear-gradient(270deg, #5f5f5f 0%, #060606 100%);
    border-radius: 0.33rem;
    box-sizing: border-box;
    padding: 0.58rem 1rem;
    margin-bottom: 1rem;
    align-items: flex-start;
    .image {
      width: 3.25rem;
      height: 3.25rem;
      border: 0.02rem solid #e3e3e3;
      margin-right: 0.67rem;
    }
    .card-content {
      position: relative;
      width: calc(100% - 3.25rem - 0.67rem);
      .title {
        font-weight: 500;
        color: #ffffff;
      }
      .star {
        margin-bottom: 0.5rem;
        .tag {
          position: relative;
          height: 1.2rem;
          line-height: 1rem;
          background: #fff3ee;
          border-radius: 0.13rem;
          border: 0.02rem solid #ff552d;
          box-sizing: border-box;
          padding: 0 0.33rem;
          text-align: center;
          font-size: 10px;
          color: #ff552d;
          margin-right: 0.25rem;
          transform: scale(0.8);
        }
      }
      .text {
        font-size: 12px;
        font-weight: 400;
        color: rgba(255, 255, 255, 0.8);
      }
    }
  }
  .store-item {
    align-items: flex-start;
    flex-wrap: nowrap;
    margin-bottom: 1rem;
    .item-label {
      width: 3rem;
      color: #666666;
    }
    .item-value {
      width: calc(100% - 3rem);
      font-size: 12px;
      font-weight: 400;
      color: #666666;
    }
  }
  .store-action {
    position: relative;
    width: 100%;
    .action-item {
      position: relative;
      background: #ffffff;
      box-sizing: border-box;
      padding: 0 1rem;
      border: 0.04rem solid #a8a8a8;
      cursor: pointer;
      margin-right: 0.83rem;
      .text {
        color: #a8a8a8;
        font-weight: 400;
        font-size: 12px;
        margin-left: 0.33rem;
      }
      &:last-child {
        border: 0.04rem solid #ff552d;
        .text {
          color: #ff552d;
        }
      }
      &:hover {
        filter: brightness(0.95);
      }
    }
  }
`;
