import React from 'react';
import styled from 'styled-components';

const TableItem: React.FC<{
  td?: React.ReactNode;
  tr?: React.ReactNode;
}> = ({ td, tr }) => {
  return (
    <OrderTableItem>
      <div className="item-td">{td}</div>
      <div className="item-tr">{tr}</div>
    </OrderTableItem>
  );
};
export default TableItem;
// 样式
const OrderTableItem = styled.div`
  .item-td {
    position: absolute;
    top: 0;
    left: 0;
    height: 36px;
    width: 100%;
    background: rgba(22, 119, 255, 0.1);
    line-height: 36px;
  }

  .item-tr {
    //min-height: 50px;
    width: 100%;
    margin-top: 28px;
  }
`;
