import React from 'react';
import styled from 'styled-components';
import { InterListType } from '@/api/interface';
import { AllCommentListType } from '@/api/interface/home';

// 详情类型
type DetailType = InterListType<AllCommentListType>[0];

const ForumReplyItem = () => {
  return (
    <ForumReplyWrap>
      <div>ForumReplyItem</div>
    </ForumReplyWrap>
  );
};

export default ForumReplyItem;
// 样式
const ForumReplyWrap = styled.div`
  position: relative;
  width: 100%;
  box-sizing: border-box;
  display: flex;
  align-items: flex-start;
  justify-content: flex-start;
  margin-bottom: 1.5rem;
  .image {
    width: 2.5rem;
    height: 2.5rem;
    border-radius: 50%;
    margin-right: 1rem;
  }
  .content {
    position: relative;
    width: calc(100% - 3.5rem);
    box-sizing: border-box;
  }
`;
