import React, { useState, useRef } from 'react'
import { Box } from './styled'
import { LeftOutlined, RightOutlined } from '@ant-design/icons'
import { WareImgsType } from '../../api'

interface ImagesType {
  imgList: Array<WareImgsType>
}
export default function PicturePreview(props: ImagesType) {
  const { imgList } = props

  const mask = useRef<HTMLDivElement>(null!)
  const moveBox = useRef<HTMLDivElement>(null!)
  const big = useRef<HTMLImageElement>(null!)
  const [moveLeft, setMoveLeft] = useState(0) // 根据这个值设置图片列表向左偏移
  // const imgList = [
  //     'https://fuss10.elemecdn.com/a/3f/3302e58f9a181d2509f3dc0fa68b0jpeg.jpeg',
  //     'https://fuss10.elemecdn.com/1/34/19aa98b1fcb2781c4fba33d850549jpeg.jpeg',
  //     'https://fuss10.elemecdn.com/0/6f/e35ff375812e6b0020b6b4e8f9583jpeg.jpeg',
  //     'https://fuss10.elemecdn.com/9/bb/e27858e973f5d7d3904835f46abbdjpeg.jpeg',
  //     'https://fuss10.elemecdn.com/d/e6/c4d93a3805b3ce3f323f7974e6f78jpeg.jpeg',
  //     'https://fuss10.elemecdn.com/3/28/bbf893f792f03a54408b3b7a7ebf0jpeg.jpeg',
  //     'https://fuss10.elemecdn.com/2/11/6535bcfb26e4c79b48ddde44f4b6fjpeg.jpeg'
  //   ]

  const [activeImgIndex, setActiveImgIndex] = useState(0)

  // 改变预览图
  const handleChangeImg = (index: number) => {
    if (index <= moveLeft + 3) setActiveImgIndex(index)
  }
  // 移动缩略图
  const handleSlide = (direction: string) => {
    //左侧按钮
    if (direction == 'left') {
      moveLeft == 0 ? setMoveLeft(0) : setMoveLeft((props) => props - 1)
    } else {
      // 右侧按钮
      if (imgList.length > 4) {
        moveLeft >= imgList.length - 4
          ? setMoveLeft(imgList.length - 4)
          : setMoveLeft((props) => props + 1)
      }
    }
  }
  // 图片放大镜
  const handleMouseMove = (
    event: React.MouseEvent<HTMLDivElement, MouseEvent>
  ) => {
    let left = event.nativeEvent.offsetX - mask.current.offsetWidth / 2
    let top = event.nativeEvent.offsetY - mask.current.offsetHeight / 2
    // 最右侧和最下侧的临界值
    const maxLeft = moveBox.current.offsetWidth - mask.current.offsetWidth
    const maxTop = moveBox.current.offsetHeight - mask.current.offsetHeight
    //约束范围
    if (left <= 0) left = 0
    if (left >= maxLeft) left = maxLeft
    if (top <= 0) top = 0
    if (top >= maxTop) top = maxTop
    // 设置放大范围遮罩层位置
    mask.current.style.left = left + 'px'
    mask.current.style.top = top + 'px'
    // 设置大图图片位置，可以用background代替这个方案，有兴趣可以尝试
    big.current.style.left = -3 * left + 'px' // 3这个值是 大图除以小图算出来的比例 这里大图是900px 小图是300px
    big.current.style.top = -3 * top + 'px'
  }
  return (
    <Box>
      <div className="img_wrapper">
        <div className="img_content">
          {/* <!--    蒙层，绑定鼠标事件   --> */}
          <div
            className="movebox"
            onMouseMove={(e) => handleMouseMove(e)}
            ref={moveBox}
          ></div>
          {/* <!--    主图   --> */}
          <img
            src={imgList && imgList[activeImgIndex].imgUrl}
            className="img_small"
            alt=""
          />
          {/* <!--  放大区域 --> */}
          <div className="mask" ref={mask}></div>
          {/* <!-- 大图预览图 --> */}
          <div className="img_big">
            <img
              src={imgList && imgList[activeImgIndex].imgUrl}
              ref={big}
              alt=""
            />
          </div>
        </div>
        {/* <!--    缩略图列表     --> */}
        <div className="img_list_wrapper">
          {imgList?.length > 4 && (
            <LeftOutlined
              className="el-icon-arrow-left"
              onClick={() => handleSlide('left')}
            />
          )}
          <div className="img_list_content">
            <div
              className="img_list"
              style={{ marginLeft: -moveLeft * 25 + '%' }}
            >
              {imgList?.map((item, index) => (
                <img
                  onMouseOver={() => handleChangeImg(index)}
                  key={index}
                  className={`${activeImgIndex === index ? 'activeImg' : ''}`}
                  src={item.imgUrl}
                  alt=""
                />
              ))}
            </div>
          </div>
          {imgList?.length > 4 && (
            <RightOutlined
              className="el-icon-arrow-right"
              onClick={() => handleSlide('right')}
            />
          )}
        </div>
      </div>
    </Box>
  )
}
