import request, { Response } from '~/api/request'

export interface GetWebDeviceDetailParams {
  goodsId: number
  type: 1
}
export interface GetLeaseGoodsParams {
  leaseTerm: number //租赁时限：（输入0：1-7天、输入1：8-15天、输入2：16-30天、输入3：30天以上）
  productSpecId: number
}

export interface WareImgsType {
  id: number
  imgUrl: string
  imgType: number
}
export interface PriceType {
  id: number
  cooperationTag: number
  price: number
  productSpecId: number
  leaseTerm: number
}

export interface GetLeaseGoodsResult {
  productSpecId: number
  type: number | null
  leaseTerm: number
  specPrice: PriceType[]
}
export interface GetWebDeviceDetailResult {
  id: number
  images: {
    id: number
    imgUrl: string
    imgType: number
  }[]
  goodsVideo: string
  goodsVideoId: number
  goodsName: string
  goodsDetail: {
    id: number
    goodsDesc: string
    content: string | null
    remark: string | null
  }
  directoryId: number
  categoryByOne: number
  categoryByTwo: null
  tag: null
  shelfStatus: number
  goodsSpec: {
    productSpecList: GetWebDeviceWareSkuById[]
  }[]
  otherService?: {
    id: number
    saleServiceId: string
    serviceName: string
  }[]
  price: number | null
  goodsNo: string
}

export interface PriceList {
  id: number
  wareInfoId: number
  skuInfoId: number
  rentPrice: number
  minDay: number
  maxDay: number
  createTime: null
}
export interface GetWebDeviceWareSkuById {
  id: number
  productSpec: number
  productSkuId: number
  specName: string
  specImage: string
  partNo: string
  versionDesc: string
  createTime: string | null
  productSpecCPQVO: string | null
}

export interface WebDeviceUpdateParams {
  id?: number
  inventoryId?: number
  inventoryUsage?: string
  startDay?: string
  endDay?: string
}

export default {
  //web-设备租赁-详情
  listDetailDeviceInfo: (
    params: GetWebDeviceDetailParams
  ): Promise<Response<GetWebDeviceDetailResult>> => {
    return request('/pms/product/mall/getLeaseGoodsDetail', 'get', params)
  },
  //web-设备租赁-立即租赁
  listWareSkuUpdate: (
    params: WebDeviceUpdateParams
  ): Promise<Response<number>> => {
    return request('/pms/appDevice/update', 'post', params)
  },
  //web-设备租赁-详情-获取设备商品规格价格详情
  GoodsPriceDetail: (
    params: GetLeaseGoodsParams
  ): Promise<Response<GetLeaseGoodsResult>> => {
    return request('/pms/product/mall/getLeaseGoodsPriceDetail', 'get', params)
  },
}
